/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.parameter.mandatory;

import java.util.List;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacetAbstract;

public abstract class MandatoryFacetForParameterAnnotation
extends MandatoryFacetAbstract {
    public MandatoryFacetForParameterAnnotation(FacetHolder holder, MandatoryFacetAbstract.Semantics semantics) {
        super(holder, semantics);
    }

    public static MandatoryFacet create(List<Parameter> parameters, Class<?> parameterType, FacetHolder holder) {
        if (parameterType.isPrimitive()) {
            return new Primitive(holder);
        }
        return parameters.stream().map(Parameter::optionality).filter(optionality -> optionality != Optionality.NOT_SPECIFIED).findFirst().map(optionality -> {
            switch (optionality) {
                case DEFAULT: {
                    return null;
                }
                case MANDATORY: {
                    return new Required(holder);
                }
                case OPTIONAL: {
                    return new Optional(holder);
                }
            }
            throw new IllegalStateException("optionality '" + optionality + "' not recognised");
        }).orElse(null);
    }

    public static class Optional
    extends MandatoryFacetForParameterAnnotation {
        public Optional(FacetHolder holder) {
            super(holder, MandatoryFacetAbstract.Semantics.OPTIONAL);
        }
    }

    public static class Required
    extends MandatoryFacetForParameterAnnotation {
        public Required(FacetHolder holder) {
            super(holder, MandatoryFacetAbstract.Semantics.REQUIRED);
        }
    }

    public static class Primitive
    extends MandatoryFacetForParameterAnnotation {
        public Primitive(FacetHolder holder) {
            super(holder, MandatoryFacetAbstract.Semantics.REQUIRED);
        }
    }
}

