/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.parameter;

import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.param.parameter.fileaccept.FileAcceptFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mandatory.MandatoryFacetInvertedByNullableAnnotationOnParameter;
import org.apache.isis.core.metamodel.facets.param.parameter.maxlen.MaxLengthFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.mustsatisfy.MustSatisfySpecificationFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.regex.RegExFacetForParameterAnnotation;
import org.apache.isis.core.metamodel.facets.param.parameter.regex.RegExFacetForPatternAnnotationOnParameter;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForConflictingOptionality;

public class ParameterAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForConflictingOptionality conflictingOptionalityValidator = new MetaModelValidatorForConflictingOptionality();

    public ParameterAnnotationFacetFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Class<?>[] parameterTypes;
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        if (paramNum >= (parameterTypes = method.getParameterTypes()).length) {
            return;
        }
        this.processParamsMaxLength(processParameterContext);
        this.processParamsMustSatisfy(processParameterContext);
        this.processParamsRegEx(processParameterContext);
        this.processParamsOptional(processParameterContext);
        this.processParamsFileAccept(processParameterContext);
    }

    void processParamsMaxLength(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        List<Parameter> parameters = Annotations.getAnnotations(method, paramNum, Parameter.class);
        FacetUtil.addFacet(MaxLengthFacetForParameterAnnotation.create(parameters, holder));
    }

    void processParamsMustSatisfy(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        List<Parameter> parameters = Annotations.getAnnotations(method, paramNum, Parameter.class);
        FacetUtil.addFacet(MustSatisfySpecificationFacetForParameterAnnotation.create(parameters, holder, this.servicesInjector));
    }

    void processParamsRegEx(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> parameterType = parameterTypes[paramNum];
        List<Pattern> patterns = Annotations.getAnnotations(method, paramNum, Pattern.class);
        FacetUtil.addFacet(RegExFacetForPatternAnnotationOnParameter.create(patterns, parameterType, holder));
        List<Parameter> parameters = Annotations.getAnnotations(method, paramNum, Parameter.class);
        FacetUtil.addFacet(RegExFacetForParameterAnnotation.create(parameters, parameterType, holder));
    }

    void processParamsOptional(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> parameterType = parameterTypes[paramNum];
        List<Nullable> nullabilities = Annotations.getAnnotations(method, paramNum, Nullable.class);
        MandatoryFacet facet = MandatoryFacetInvertedByNullableAnnotationOnParameter.create(nullabilities, parameterType, holder);
        FacetUtil.addFacet(facet);
        this.conflictingOptionalityValidator.flagIfConflict(facet, "Conflicting @Nullable with other optionality annotation");
        List<Parameter> parameters = Annotations.getAnnotations(method, paramNum, Parameter.class);
        MandatoryFacet mandatoryFacet = MandatoryFacetForParameterAnnotation.create(parameters, parameterType, holder);
        FacetUtil.addFacet(mandatoryFacet);
        this.conflictingOptionalityValidator.flagIfConflict(mandatoryFacet, "Conflicting @Parameter#optionality with other optionality annotation");
    }

    void processParamsFileAccept(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        FacetedMethodParameter holder = (FacetedMethodParameter)processParameterContext.getFacetHolder();
        List<Parameter> parameters = Annotations.getAnnotations(method, paramNum, Parameter.class);
        FacetUtil.addFacet(FileAcceptFacetForParameterAnnotation.create(parameters, holder));
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(this.conflictingOptionalityValidator);
    }
}

