/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.choices.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;

public class ActionChoicesFacetViaMethod
extends ActionChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;
    private final SpecificationLoader specificationLoader;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ObjectAdapterProvider adapterProvider;

    public ActionChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.method = method;
        this.choicesType = choicesType;
        this.specificationLoader = specificationLoader;
        this.authenticationSessionProvider = authenticationSessionProvider;
        this.adapterProvider = adapterProvider;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public Object[][] getChoices(ObjectAdapter owningAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        Object objectOrCollection = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (!(objectOrCollection instanceof Object[])) {
            throw new DomainModelException(String.format("Expected an array of collections (Object[]) containing choices for all parameters, but got %s instead. Perhaps the parameter number is missing?", objectOrCollection));
        }
        Object[] options = (Object[])objectOrCollection;
        Object[][] results = new Object[options.length][];
        for (int i = 0; i < results.length; ++i) {
            Class<?> parameterType = this.method.getParameterTypes()[i];
            results[i] = this.handleResults(options[i], parameterType, interactionInitiatedBy);
        }
        return results;
    }

    private Object[] handleResults(Object collectionOrArray, Class<?> parameterType, InteractionInitiatedBy interactionInitiatedBy) {
        if (collectionOrArray == null) {
            return null;
        }
        ObjectAdapter collectionAdapter = this.getObjectAdapterProvider().adapterFor(collectionOrArray);
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy);
        List filteredObjects = _Lists.map(visibleAdapters, ObjectAdapter.Util::unwrapPojo);
        ObjectSpecification parameterSpec = this.getSpecification(parameterType);
        return CollectionUtils.getCollectionAsObjectArray(filteredObjects, parameterSpec, this.getObjectAdapterProvider());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }

    protected ObjectSpecification getSpecification(Class<?> type) {
        return type != null ? this.getSpecificationLoader().loadSpecification(type) : null;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
        attributeMap.put("choicesType", this.choicesType);
    }
}

