/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.objectvalue.mustsatisfyspec;

import java.util.List;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.spec.Specification;
import org.apache.isis.applib.spec.Specification2;
import org.apache.isis.applib.util.ReasonBuffer;

public class SpecificationEvaluator {
    private final TranslationService translationService;
    private final String translationContext;

    public SpecificationEvaluator(TranslationService translationService, String translationContext) {
        this.translationService = translationService;
        this.translationContext = translationContext;
    }

    public Evaluation evaluation() {
        return new Evaluation();
    }

    public class Evaluation {
        final ReasonBuffer reasonBuffer = new ReasonBuffer();

        public Evaluation evaluate(List<Specification> specifications, Object proposedObject) {
            for (Specification specification : specifications) {
                this.evaluate(specification, proposedObject);
            }
            return this;
        }

        public Evaluation evaluate(Specification specification, Object proposedObject) {
            if (specification instanceof Specification2) {
                Specification2 specification2 = (Specification2)specification;
                TranslatableString translatableReason = specification2.satisfiesTranslatable(proposedObject);
                if (translatableReason != null) {
                    String translatedReason = translatableReason.translate(SpecificationEvaluator.this.translationService, SpecificationEvaluator.this.translationContext);
                    this.reasonBuffer.append(translatedReason);
                }
            } else {
                String satisfies = specification.satisfies(proposedObject);
                this.reasonBuffer.append(satisfies);
            }
            return this;
        }

        public String getReason() {
            return this.reasonBuffer.getReason();
        }
    }
}

