/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.value.annotcfg;

import org.apache.isis.applib.annotation.Value;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderUtil;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class ValueFacetAnnotation
extends ValueFacetAbstract {
    private static String semanticsProviderName(Class<?> annotatedClass) {
        Value annotation = annotatedClass.getAnnotation(Value.class);
        String semanticsProviderName = annotation.semanticsProviderName();
        if (!_Strings.isNullOrEmpty((CharSequence)semanticsProviderName)) {
            return semanticsProviderName;
        }
        return ValueSemanticsProviderUtil.semanticsProviderNameFromConfiguration(annotatedClass, _Config.getConfiguration());
    }

    private static Class<?> semanticsProviderClass(Class<?> annotatedClass) {
        Value annotation = annotatedClass.getAnnotation(Value.class);
        return annotation.semanticsProviderClass();
    }

    public ValueFacetAnnotation(Class<?> annotatedClass, FacetHolder holder, ServicesInjector injector) {
        this(ValueFacetAnnotation.semanticsProviderName(annotatedClass), ValueFacetAnnotation.semanticsProviderClass(annotatedClass), holder, injector);
    }

    private ValueFacetAnnotation(String candidateSemanticsProviderName, Class<?> candidateSemanticsProviderClass, FacetHolder holder, ServicesInjector injector) {
        super(ValueSemanticsProviderUtil.valueSemanticsProviderOrNull(candidateSemanticsProviderClass, candidateSemanticsProviderName), ValueFacetAbstract.AddFacetsIfInvalidStrategy.DO_ADD, holder, injector);
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

