/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.title.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleFacetViaTitleAnnotation
extends TitleFacetAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(TitleFacetViaTitleAnnotation.class);
    private final List<TitleComponent> components;
    private final ObjectAdapterProvider adapterProvider;

    public TitleFacetViaTitleAnnotation(List<TitleComponent> components, FacetHolder holder, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.components = components;
        this.adapterProvider = adapterProvider;
    }

    @Override
    public String title(ManagedObject targetAdapter) {
        return this.title(null, targetAdapter);
    }

    private String titleOf(ManagedObject adapter) {
        if (adapter == null) {
            return null;
        }
        return adapter.titleString(null);
    }

    public List<TitleComponent> getComponents() {
        return this.components;
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    @Override
    public String title(ManagedObject contextAdapter, ManagedObject targetAdapter) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (TitleComponent component : this.components) {
                ObjectAdapter titlePartAdapter;
                Object titlePart = component.getTitleEvaluator().value(targetAdapter.getPojo());
                if (titlePart == null || Objects.equals(contextAdapter, titlePartAdapter = this.adapterProvider.adapterFor(titlePart))) continue;
                String title = this.titleOf(titlePartAdapter);
                if (_Strings.isNullOrEmpty((CharSequence)title)) {
                    title = titlePart.toString().trim();
                }
                if (_Strings.isNullOrEmpty((CharSequence)title)) continue;
                stringBuilder.append(component.getPrepend());
                stringBuilder.append(TitleFacetViaTitleAnnotation.abbreviated(title, component.abbreviateTo));
                stringBuilder.append(component.getAppend());
            }
            return stringBuilder.toString().trim();
        }
        catch (RuntimeException ex) {
            LOG.warn("Title failure", (Throwable)ex);
            return "Failed Title";
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        if (this.components != null && !_Strings.isNullOrEmpty((CharSequence)this.components.toString())) {
            attributeMap.put("components", this.components);
        }
    }

    public static class TitleComponent {
        public static final Function<Annotations.Evaluator<Title>, TitleComponent> FROM_EVALUATORS = titleEvaluator -> TitleComponent.of(titleEvaluator);
        private final String prepend;
        private final String append;
        private final Annotations.Evaluator<Title> titleEvaluator;
        private final int abbreviateTo;

        private TitleComponent(String prepend, String append, Annotations.Evaluator<Title> titleEvaluator, int abbreviateTo) {
            this.prepend = prepend;
            this.append = append;
            this.titleEvaluator = titleEvaluator;
            this.abbreviateTo = abbreviateTo;
        }

        public String getPrepend() {
            return this.prepend;
        }

        public String getAppend() {
            return this.append;
        }

        public Annotations.Evaluator<Title> getTitleEvaluator() {
            return this.titleEvaluator;
        }

        private static TitleComponent of(Annotations.Evaluator<Title> titleEvaluator) {
            Title annotation = titleEvaluator.getAnnotation();
            String prepend = annotation != null ? annotation.prepend() : " ";
            String append = annotation != null ? annotation.append() : "";
            int abbreviateTo = annotation != null ? annotation.abbreviatedTo() : Integer.MAX_VALUE;
            return new TitleComponent(prepend, append, titleEvaluator, abbreviateTo);
        }

        public String toString() {
            ArrayList parts = _Lists.newArrayList();
            if (this.prepend != null && !_Strings.isNullOrEmpty((CharSequence)this.prepend.trim())) {
                parts.add("prepend=" + this.prepend);
            }
            if (this.append != null && !_Strings.isNullOrEmpty((CharSequence)this.append.trim())) {
                parts.add("append=" + this.append);
            }
            if (this.abbreviateTo != Integer.MAX_VALUE) {
                parts.add("abbreviateTo=" + this.abbreviateTo);
            }
            return String.join((CharSequence)";", parts);
        }
    }
}

