/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.recreatable;

import java.util.Set;
import java.util.stream.Stream;
import org.apache.isis.applib.services.urlencoding.UrlEncodingService;
import org.apache.isis.commons.internal.memento._Mementos;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public abstract class RecreatableObjectFacetDeclarativeInitializingAbstract
extends RecreatableObjectFacetAbstract {
    private final ObjectAdapterProvider adapterProvider;

    public RecreatableObjectFacetDeclarativeInitializingAbstract(FacetHolder holder, ViewModelFacet.RecreationMechanism recreationMechanism, ObjectAdapterProvider adapterProvider, ServicesInjector servicesInjector, PostConstructMethodCache postConstructMethodCache) {
        super(holder, recreationMechanism, postConstructMethodCache, servicesInjector);
        this.adapterProvider = adapterProvider;
    }

    @Override
    protected void doInitialize(Object viewModelPojo, String mementoStr) {
        UrlEncodingService codec = (UrlEncodingService)this.servicesInjector.lookupServiceElseFail(UrlEncodingService.class);
        _Mementos.SerializingAdapter serializer = (_Mementos.SerializingAdapter)this.servicesInjector.lookupServiceElseFail(_Mementos.SerializingAdapter.class);
        _Mementos.Memento memento = _Mementos.parse((_Mementos.EncoderDecoder)codec, (_Mementos.SerializingAdapter)serializer, (String)mementoStr);
        Set mementoKeys = memento.keySet();
        ObjectAdapter viewModelAdapter = this.adapterProvider.adapterForViewModel(viewModelPojo, mementoStr);
        ObjectSpecification spec = viewModelAdapter.getSpecification();
        Stream<OneToOneAssociation> properties = spec.streamProperties(Contributed.EXCLUDED);
        properties.forEach(property -> {
            String propertyId = property.getId();
            Object propertyValue = null;
            if (mementoKeys.contains(propertyId)) {
                Class<?> propertyType = property.getSpecification().getCorrespondingClass();
                propertyValue = memento.get(propertyId, propertyType);
            }
            if (propertyValue != null) {
                property.set(viewModelAdapter, this.adapterProvider.adapterFor(propertyValue), InteractionInitiatedBy.FRAMEWORK);
            }
        });
    }

    @Override
    public String memento(Object viewModelPojo) {
        UrlEncodingService codec = (UrlEncodingService)this.servicesInjector.lookupServiceElseFail(UrlEncodingService.class);
        _Mementos.SerializingAdapter serializer = (_Mementos.SerializingAdapter)this.servicesInjector.lookupServiceElseFail(_Mementos.SerializingAdapter.class);
        _Mementos.Memento memento = _Mementos.create((_Mementos.EncoderDecoder)codec, (_Mementos.SerializingAdapter)serializer);
        ManagedObject ownerAdapter = this.adapterProvider.disposableAdapterForViewModel(viewModelPojo);
        ObjectSpecification spec = ownerAdapter.getSpecification();
        Stream<OneToOneAssociation> properties = spec.streamProperties(Contributed.EXCLUDED);
        properties.filter(property -> property.containsDoOpFacet(PropertySetterFacet.class)).filter(property -> !property.isNotPersisted()).forEach(property -> {
            ManagedObject propertyValue = property.get2(ownerAdapter, InteractionInitiatedBy.FRAMEWORK);
            if (propertyValue != null) {
                memento.put(property.getId(), propertyValue.getPojo());
            }
        });
        return memento.asString();
    }
}

