/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.objectspecid.classname;

import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.ObjectSpecIdFacetFactory;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.facets.object.objectspecid.classname.ObjectSpecIdFacetDerivedFromClassName;
import org.apache.isis.core.metamodel.facets.object.objectspecid.classname.ObjectSpecIdFacetDerivedFromDomainServiceAnnotationElseGetId;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class ObjectSpecIdFacetDerivedFromClassNameFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
ObjectSpecIdFacetFactory {
    public static final String ISIS_REFLECTOR_VALIDATOR_EXPLICIT_OBJECT_TYPE_KEY = "isis.reflector.validator.explicitObjectType";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_EXPLICIT_OBJECT_TYPE_DEFAULT = false;
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();

    public ObjectSpecIdFacetDerivedFromClassNameFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(ObjectSpecIdFacetFactory.ProcessObjectSpecIdContext processClassContext) {
        Object facetHolder = processClassContext.getFacetHolder();
        if (facetHolder.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            return;
        }
        Class<?> cls = processClassContext.getCls();
        Class<?> substitutedClass = this.classSubstitutor.getClass(cls);
        ObjectSpecIdFacet objectSpecIdFacet = ObjectSpecIdFacetDerivedFromClassNameFactory.createObjectSpecIdFacet(facetHolder, substitutedClass);
        FacetUtil.addFacet(objectSpecIdFacet);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
    }

    private static ObjectSpecIdFacet createObjectSpecIdFacet(FacetHolder facetHolder, Class<?> substitutedClass) {
        String id;
        boolean isService = ObjectSpecIdFacetDerivedFromClassNameFactory.isService(facetHolder);
        if (isService && (id = (String)ServiceUtil.getExplicitIdOfType(substitutedClass).orElse(null)) != null) {
            return new ObjectSpecIdFacetDerivedFromDomainServiceAnnotationElseGetId(id, facetHolder);
        }
        return new ObjectSpecIdFacetDerivedFromClassName(substitutedClass, facetHolder);
    }

    private static boolean isService(FacetHolder facetHolder) {
        if (facetHolder instanceof ObjectSpecification) {
            ObjectSpecification objectSpecification = (ObjectSpecification)facetHolder;
            return objectSpecification.isService();
        }
        return false;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        boolean doCheck = _Config.getConfiguration().getBoolean(ISIS_REFLECTOR_VALIDATOR_EXPLICIT_OBJECT_TYPE_KEY, false);
        if (!doCheck) {
            return;
        }
        MetaModelValidatorVisiting validator = new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                if (this.skip(objectSpec)) {
                    return;
                }
                ObjectSpecIdFacet objectSpecIdFacet = objectSpec.getFacet(ObjectSpecIdFacet.class);
                if (objectSpecIdFacet instanceof ObjectSpecIdFacetDerivedFromClassName && !FixtureScript.class.isAssignableFrom(objectSpec.getCorrespondingClass())) {
                    validationFailures.add("%s: the object type must be specified explicitly ('%s' config property).  Defaulting the object type from the package/class/package name can lead to data migration issues for apps deployed to production (if the class is subsequently refactored).  Use @Discriminator, @DomainObject(objectType=...) or @PersistenceCapable(schema=...) to specify explicitly.", objectSpec.getFullIdentifier(), ObjectSpecIdFacetDerivedFromClassNameFactory.ISIS_REFLECTOR_VALIDATOR_EXPLICIT_OBJECT_TYPE_KEY);
                }
            }

            private boolean skip(ObjectSpecification objectSpec) {
                return !ObjectSpecIdFacetDerivedFromClassNameFactory.check(objectSpec);
            }
        });
        metaModelValidator.add(validator);
    }

    public static boolean check(ObjectSpecification objectSpec) {
        if (objectSpec.isAbstract()) {
            return false;
        }
        if (objectSpec.isPersistenceCapable()) {
            return true;
        }
        if (objectSpec.isViewModel()) {
            ViewModelFacet viewModelFacet = objectSpec.getFacet(ViewModelFacet.class);
            XmlType xmlType = objectSpec.getCorrespondingClass().getAnnotation(XmlType.class);
            return xmlType == null;
        }
        if (objectSpec.isMixin()) {
            return false;
        }
        if (objectSpec.isService()) {
            DomainServiceFacet domainServiceFacet = objectSpec.getFacet(DomainServiceFacet.class);
            if (domainServiceFacet != null && (domainServiceFacet.getNatureOfService() == NatureOfService.DOMAIN || domainServiceFacet.getNatureOfService() == NatureOfService.VIEW_CONTRIBUTIONS_ONLY)) {
                return false;
            }
            Stream<ObjectAction> objectActions = objectSpec.streamObjectActions(Contributed.INCLUDED);
            return objectActions.anyMatch(__ -> true);
        }
        return false;
    }
}

