/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.navparent.method;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.isis.core.commons.reflection.Reflect;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.navparent.NavigableParentFacetAbstract;

public class NavigableParentFacetMethod
extends NavigableParentFacetAbstract {
    private final MethodHandle methodHandle;

    public NavigableParentFacetMethod(Method method, FacetHolder holder) throws IllegalAccessException {
        super(holder);
        this.methodHandle = Reflect.handleOf(method);
    }

    @Override
    public Object navigableParent(Object object) {
        try {
            return this.methodHandle.invoke(object);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("methodHandle", this.methodHandle);
    }
}

