/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.mixin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.isis.applib.services.title.TitleService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class MixinFacetAbstract
extends SingleValueFacetAbstract<String>
implements MixinFacet {
    private final Class<?> mixinType;
    private final Class<?> constructorType;
    private final ServicesInjector servicesInjector;

    public static Class<? extends Facet> type() {
        return MixinFacet.class;
    }

    public MixinFacetAbstract(Class<?> mixinType, String value, Class<?> constructorType, FacetHolder holder, ServicesInjector servicesInjector) {
        super(MixinFacetAbstract.type(), value, holder);
        this.mixinType = mixinType;
        this.constructorType = constructorType;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public boolean isMixinFor(Class<?> candidateDomainType) {
        if (candidateDomainType == null) {
            return false;
        }
        return this.constructorType.isAssignableFrom(candidateDomainType);
    }

    @Override
    public Object instantiate(Object domainPojo) {
        if (domainPojo == null) {
            return null;
        }
        if (!this.constructorType.isAssignableFrom(domainPojo.getClass())) {
            return null;
        }
        try {
            Constructor<?> constructor = this.mixinType.getConstructor(this.constructorType);
            Object mixinPojo = constructor.newInstance(domainPojo);
            this.servicesInjector.injectServicesInto(mixinPojo);
            return mixinPojo;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public ObjectAdapter mixedIn(ObjectAdapter mixinAdapter, MixinFacet.Policy policy) {
        Field[] declaredFields;
        Object mixin = mixinAdapter.getPojo();
        for (Field declaredField : declaredFields = this.mixinType.getDeclaredFields()) {
            if (!declaredField.getType().isAssignableFrom(this.constructorType)) continue;
            declaredField.setAccessible(true);
            try {
                Object o = declaredField.get(mixin);
                return this.getObjectAdapterProvider().adapterFor(o);
            }
            catch (IllegalAccessException e) {
                if (policy != MixinFacet.Policy.FAIL_FAST) continue;
                throw new RuntimeException("Unable to access " + declaredField + " for " + this.getTitleService().titleOf(mixin));
            }
        }
        if (policy == MixinFacet.Policy.FAIL_FAST) {
            throw new RuntimeException("Could not find the \"mixed-in\" domain object within " + this.getTitleService().titleOf(mixin) + " (tried to guess by looking at all private fields and matching one against the constructor parameter)");
        }
        return null;
    }

    private ObjectAdapterProvider getObjectAdapterProvider() {
        return this.servicesInjector.getPersistenceSessionServiceInternal();
    }

    private TitleService getTitleService() {
        return (TitleService)this.servicesInjector.lookupServiceElseFail(TitleService.class);
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("mixinType", this.mixinType);
        attributeMap.put("constructorType", this.constructorType);
    }
}

