/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.mixin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForValidationFailures;

public class MetaModelValidatorForMixinTypes
extends MetaModelValidatorForValidationFailures {
    private final String annotation;

    public MetaModelValidatorForMixinTypes(String annotation) {
        this.annotation = annotation;
    }

    public boolean ensureMixinType(Class<?> candidateMixinType) {
        boolean mixinType = MetaModelValidatorForMixinTypes.has1ArgConstructor(candidateMixinType);
        if (mixinType) {
            return true;
        }
        this.addFailure("%s: annotated with %s annotation but does not have a public 1-arg constructor", candidateMixinType.getName(), this.annotation);
        return false;
    }

    private static boolean has1ArgConstructor(Class<?> cls) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }
}

