/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.ignore.jdo;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.ignore.javalang.RemoveMethodsFacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class RemoveJdoEnhancementTypesFacetFactory
extends FacetFactoryAbstract {
    private final List<RemoveMethodsFacetFactory.MethodAndParameterTypes> jdoEnhancementmethodsToIgnore = _Lists.newArrayList();

    public RemoveJdoEnhancementTypesFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
        String typeToIgnoreIfOnClasspath = "javax.jdo.spi.PersistenceCapable";
        try {
            Class<?> typeToIgnore = InstanceUtil.loadClass("javax.jdo.spi.PersistenceCapable");
            this.addMethodsToBeIgnored(typeToIgnore);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addMethodsToBeIgnored(Class<?> typeToIgnore) {
        Method[] methods;
        for (Method method : methods = typeToIgnore.getMethods()) {
            this.jdoEnhancementmethodsToIgnore.add(new RemoveMethodsFacetFactory.MethodAndParameterTypes(method.getName(), method.getParameterTypes()));
        }
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        for (RemoveMethodsFacetFactory.MethodAndParameterTypes mapt : this.jdoEnhancementmethodsToIgnore) {
            processClassContext.removeMethod(MethodScope.OBJECT, mapt.methodName, null, mapt.methodParameters);
        }
    }
}

