/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.events.ui.CssClassUiEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.util.EventUtil;

public class CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent
extends FacetAbstract
implements CssClassFacet {
    private final Class<? extends CssClassUiEvent<?>> cssClassUiEventClass;
    private final EventBusService eventBusService;

    public static Facet create(List<DomainObjectLayout> domainObjectLayouts, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        return domainObjectLayouts.stream().map(DomainObjectLayout::cssClassUiEvent).filter(cssClassUiEventClass -> EventUtil.eventTypeIsPostable(cssClassUiEventClass, CssClassUiEvent.Noop.class, CssClassUiEvent.Default.class, "isis.reflector.facet.domainObjectLayoutAnnotation.cssClassUiEvent.postForDefault", configuration)).findFirst().map(cssClassUiEventClass -> {
            EventBusService eventBusService = (EventBusService)servicesInjector.lookupServiceElseFail(EventBusService.class);
            return new CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent((Class<? extends CssClassUiEvent<?>>)cssClassUiEventClass, eventBusService, facetHolder);
        }).orElse(null);
    }

    public CssClassFacetViaDomainObjectLayoutAnnotationUsingCssClassUiEvent(Class<? extends CssClassUiEvent<?>> cssClassUiEventClass, EventBusService eventBusService, FacetHolder holder) {
        super(CssClassFacetAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.cssClassUiEventClass = cssClassUiEventClass;
        this.eventBusService = eventBusService;
    }

    @Override
    public String cssClass(ManagedObject owningAdapter) {
        Facet underlyingFacet;
        if (owningAdapter == null) {
            return null;
        }
        CssClassUiEvent<Object> cssClassUiEvent = this.newCssClassUiEvent(owningAdapter);
        this.eventBusService.post(cssClassUiEvent);
        String cssClass = cssClassUiEvent.getCssClass();
        if (cssClass == null && (underlyingFacet = this.getUnderlyingFacet()) instanceof CssClassFacet) {
            CssClassFacet underlyingCssClassFacet = (CssClassFacet)underlyingFacet;
            return underlyingCssClassFacet.cssClass(owningAdapter);
        }
        return cssClass;
    }

    private CssClassUiEvent<Object> newCssClassUiEvent(ManagedObject owningAdapter) {
        Object domainObject = owningAdapter.getPojo();
        return this.newCssClassUiEventForPojo(domainObject);
    }

    private CssClassUiEvent<Object> newCssClassUiEventForPojo(Object domainObject) {
        try {
            CssClassUiEvent cssClassUiEvent = (CssClassUiEvent)_Casts.uncheckedCast(this.cssClassUiEventClass.newInstance());
            cssClassUiEvent.setSource(domainObject);
            return cssClassUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("cssClassUiEventClass", this.cssClassUiEventClass);
    }
}

