/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.auditing;

import java.util.List;
import org.apache.isis.applib.annotation.Auditing;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForDomainObjectAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetFromConfiguration;

public class AuditableFacetForDomainObjectAnnotation
extends AuditableFacetAbstract {
    public static AuditableFacet create(List<DomainObject> domainObjects, IsisConfiguration configuration, FacetHolder holder) {
        return domainObjects.stream().filter(domainObject -> domainObject.auditing() != Auditing.NOT_SPECIFIED).findFirst().map(domainObject -> {
            switch (domainObject.auditing()) {
                case DISABLED: {
                    return new AuditableFacetForDomainObjectAnnotation(AuditableFacetAbstract.Enablement.DISABLED, holder);
                }
                case ENABLED: {
                    return new AuditableFacetForDomainObjectAnnotation(AuditableFacetAbstract.Enablement.ENABLED, holder);
                }
                case AS_CONFIGURED: 
                case NOT_SPECIFIED: {
                    return new AuditableFacetForDomainObjectAnnotationAsConfigured(holder);
                }
            }
            throw _Exceptions.unmatchedCase((Object)domainObject.auditing());
        }).orElse(new AuditableFacetFromConfiguration(holder));
    }

    protected AuditableFacetForDomainObjectAnnotation(AuditableFacetAbstract.Enablement enablement, FacetHolder holder) {
        super(holder, enablement);
    }
}

