/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.defaults;

import java.util.Map;
import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultedFacet;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultedFacetUsingDefaultsProvider;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultsProviderUtil;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class DefaultedFacetAbstract
extends FacetAbstract
implements DefaultedFacet {
    private final Class<?> defaultsProviderClass;
    private final DefaultedFacetUsingDefaultsProvider defaultedFacetUsingDefaultsProvider;
    private final ServicesInjector dependencyInjector;

    public DefaultedFacetAbstract(String candidateEncoderDecoderName, Class<?> candidateEncoderDecoderClass, FacetHolder holder, ServicesInjector dependencyInjector) {
        super(DefaultedFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.defaultsProviderClass = DefaultsProviderUtil.defaultsProviderOrNull(candidateEncoderDecoderClass, candidateEncoderDecoderName);
        this.dependencyInjector = dependencyInjector;
        if (this.isValid()) {
            DefaultsProvider defaultsProvider = (DefaultsProvider)ClassExtensions.newInstance(this.defaultsProviderClass, FacetHolder.class, holder);
            this.defaultedFacetUsingDefaultsProvider = new DefaultedFacetUsingDefaultsProvider(defaultsProvider, holder, this.getDependencyInjector());
        } else {
            this.defaultedFacetUsingDefaultsProvider = null;
        }
    }

    public boolean isValid() {
        return this.defaultsProviderClass != null;
    }

    public Class<?> getDefaultsProviderClass() {
        return this.defaultsProviderClass;
    }

    @Override
    public Object getDefault() {
        return this.defaultedFacetUsingDefaultsProvider.getDefault();
    }

    @Override
    protected String toStringValues() {
        return this.defaultsProviderClass.getName();
    }

    private ServicesInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("defaultsProviderClass", this.defaultsProviderClass);
    }
}

