/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.cssclassfa;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleStringValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;

public class CssClassFaFacetAbstract
extends SingleStringValueFacetAbstract
implements CssClassFaFacet {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private CssClassFaPosition position;

    public CssClassFaFacetAbstract(String value, CssClassFaPosition position, FacetHolder holder) {
        super(CssClassFaFacetAbstract.type(), holder, CssClassFaFacetAbstract.sanitize(value));
        this.position = position;
    }

    @Override
    public CssClassFaPosition getPosition() {
        return this.position;
    }

    static String sanitize(String value) {
        Stream classes = _Strings.splitThenStream((CharSequence)value.trim(), (Pattern)WHITESPACE);
        LinkedHashSet cssClassesSet = _Sets.newLinkedHashSet();
        cssClassesSet.add("fa");
        cssClassesSet.add("fa-fw");
        classes.forEach(cssClass -> cssClassesSet.add(CssClassFaFacetAbstract.faPrefix(cssClass)));
        return cssClassesSet.stream().collect(Collectors.joining(" ")).trim();
    }

    private static String faPrefix(String cssClass) {
        return cssClass.startsWith("fa-") || "fa".equals(cssClass) ? cssClass : "fa-" + cssClass;
    }

    public static Class<? extends Facet> type() {
        return CssClassFaFacet.class;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("position", (Object)this.position);
    }
}

