/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.layout;

import java.util.List;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.facets.collections.layout.CssClassFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.DefaultViewFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.DescribedAsFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.HiddenFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.NamedFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.PagedFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.SortedByFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;

public class CollectionLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public CollectionLayoutFacetFactory() {
        super(FeatureType.COLLECTIONS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Object holder = processMethodContext.getFacetHolder();
        List<CollectionLayout> collectionLayouts = Annotations.getAnnotations(processMethodContext.getMethod(), CollectionLayout.class);
        CssClassFacet cssClassFacet = CssClassFacetForCollectionLayoutAnnotation.create(collectionLayouts, holder);
        FacetUtil.addFacet(cssClassFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetForCollectionLayoutAnnotation.create(collectionLayouts, holder);
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetForCollectionLayoutAnnotation.create(collectionLayouts, holder);
        FacetUtil.addFacet(hiddenFacet);
        DefaultViewFacet defaultViewFacet = DefaultViewFacetForCollectionLayoutAnnotation.create(collectionLayouts, this.getConfiguration(), holder);
        FacetUtil.addFacet(defaultViewFacet);
        NamedFacet namedFacet = NamedFacetForCollectionLayoutAnnotation.create(collectionLayouts, holder);
        FacetUtil.addFacet(namedFacet);
        PagedFacet pagedFacet = PagedFacetForCollectionLayoutAnnotation.create(collectionLayouts, holder);
        FacetUtil.addFacet(pagedFacet);
        SortedByFacet sortedByFacet = SortedByFacetForCollectionLayoutAnnotation.create(collectionLayouts, holder);
        FacetUtil.addFacet(sortedByFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Facet cssClassFacet = null;
        FacetUtil.addFacet(cssClassFacet);
        Facet describedAsFacet = null;
        FacetUtil.addFacet(describedAsFacet);
        MultiTypedFacet hiddenFacet = null;
        FacetUtil.addFacet(hiddenFacet);
        Facet namedFacet = null;
        FacetUtil.addFacet(namedFacet);
        Facet pagedFacet = null;
        FacetUtil.addFacet(pagedFacet);
        Facet sortedByFacet = null;
        FacetUtil.addFacet(sortedByFacet);
    }
}

