/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.javautilcollection;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class JavaArrayFacet
extends CollectionFacetAbstract {
    private final ObjectAdapterProvider adapterProvider;

    public JavaArrayFacet(FacetHolder holder, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.adapterProvider = adapterProvider;
    }

    @Override
    public <T extends ManagedObject> Object populatePojo(Supplier<Object> emptyCollectionPojoFactory, ObjectSpecification collectionSpec, Stream<T> initData, int elementCount) {
        Object[] array = (Object[])initData.map(ManagedObject::getPojo).collect(_Arrays.toArray(Object.class, (int)elementCount));
        return array;
    }

    @Override
    public <T extends ManagedObject> Stream<T> stream(T arrayAdapter) {
        Object[] array = this.pojoArray(arrayAdapter);
        if (_NullSafe.isEmpty((Object[])array)) {
            return Stream.of(new ManagedObject[0]);
        }
        return Stream.of(array).map(this.getObjectAdapterProvider()::adapterFor).map(x -> x);
    }

    @Override
    public int size(ManagedObject arrayAdapter) {
        return this.pojoArray(arrayAdapter).length;
    }

    private Object[] pojoArray(ManagedObject arrayAdapter) {
        return (Object[])arrayAdapter.getPojo();
    }

    private ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }
}

