/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.collection.modify;

import java.util.Collection;
import java.util.Map;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.events.domain.CollectionDomainEvent;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public abstract class CollectionRemoveFromFacetForDomainEventFromAbstract
extends SingleValueFacetAbstract<Class<? extends CollectionDomainEvent<?, ?>>>
implements CollectionRemoveFromFacet {
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final CollectionRemoveFromFacet collectionRemoveFromFacet;
    private final CollectionDomainEventFacetAbstract collectionDomainEventFacet;
    private final DomainEventHelper domainEventHelper;

    public static Class<? extends Facet> type() {
        return CollectionRemoveFromFacet.class;
    }

    public CollectionRemoveFromFacetForDomainEventFromAbstract(Class<? extends CollectionDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, CollectionRemoveFromFacet collectionRemoveFromFacet, CollectionDomainEventFacetAbstract collectionDomainEventFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(CollectionRemoveFromFacetForDomainEventFromAbstract.type(), eventType, holder);
        this.getterFacet = getterFacet;
        this.collectionRemoveFromFacet = collectionRemoveFromFacet;
        this.collectionDomainEventFacet = collectionDomainEventFacet;
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public void remove(ObjectAdapter targetAdapter, ObjectAdapter referencedObjectAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        if (this.collectionRemoveFromFacet == null) {
            return;
        }
        Object referencedObject = ObjectAdapter.Util.unwrapPojo(referencedObjectAdapter);
        Object collection = this.getterFacet.getProperty(targetAdapter, interactionInitiatedBy);
        if (!((Collection)collection).contains(referencedObject)) {
            return;
        }
        ManagedObject mixedInAdapter = null;
        CollectionDomainEvent event = this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.EXECUTING, this.getEventType(), null, this.getIdentified(), targetAdapter, mixedInAdapter, CollectionDomainEvent.Of.REMOVE_FROM, referencedObject);
        this.collectionRemoveFromFacet.remove(targetAdapter, referencedObjectAdapter, interactionInitiatedBy);
        this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.EXECUTED, this.getEventType(), (CollectionDomainEvent)_Casts.uncheckedCast(event), this.getIdentified(), targetAdapter, mixedInAdapter, CollectionDomainEvent.Of.REMOVE_FROM, referencedObject);
    }

    public <S, T> Class<? extends CollectionDomainEvent<S, T>> getEventType() {
        return (Class)_Casts.uncheckedCast(this.value());
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("getterFacet", this.getterFacet);
        attributeMap.put("collectionRemoveFromFacet", this.collectionRemoveFromFacet);
    }
}

