/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.collection.modify;

import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.events.domain.CollectionDomainEvent;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public abstract class CollectionAddToFacetForDomainEventFromAbstract
extends SingleValueFacetAbstract<Class<? extends CollectionDomainEvent<?, ?>>>
implements CollectionAddToFacet {
    private final DomainEventHelper domainEventHelper;
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final CollectionAddToFacet collectionAddToFacet;
    private final CollectionDomainEventFacetAbstract collectionDomainEventFacet;

    public static Class<? extends Facet> type() {
        return CollectionAddToFacet.class;
    }

    public CollectionAddToFacetForDomainEventFromAbstract(Class<? extends CollectionDomainEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, CollectionAddToFacet collectionAddToFacet, CollectionDomainEventFacetAbstract collectionDomainEventFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(CollectionAddToFacetForDomainEventFromAbstract.type(), eventType, holder);
        this.getterFacet = getterFacet;
        this.collectionAddToFacet = collectionAddToFacet;
        this.collectionDomainEventFacet = collectionDomainEventFacet;
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public void add(ObjectAdapter targetAdapter, ObjectAdapter referencedObjectAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        Set set;
        if (this.collectionAddToFacet == null) {
            return;
        }
        Object referencedObject = ObjectAdapter.Util.unwrapPojo(referencedObjectAdapter);
        Object collection = this.getterFacet.getProperty(targetAdapter, interactionInitiatedBy);
        if (collection instanceof Set && (set = (Set)collection).contains(referencedObject)) {
            return;
        }
        ManagedObject mixedInAdapter = null;
        CollectionDomainEvent event = this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.EXECUTING, this.getEventType(), null, this.getIdentified(), targetAdapter, mixedInAdapter, CollectionDomainEvent.Of.ADD_TO, referencedObject);
        this.collectionAddToFacet.add(targetAdapter, referencedObjectAdapter, interactionInitiatedBy);
        this.domainEventHelper.postEventForCollection(AbstractDomainEvent.Phase.EXECUTED, this.getEventType(), (CollectionDomainEvent)_Casts.uncheckedCast(event), this.getIdentified(), targetAdapter, mixedInAdapter, CollectionDomainEvent.Of.ADD_TO, referencedObject);
    }

    public <S, T> Class<? extends CollectionDomainEvent<S, T>> getEventType() {
        return (Class)_Casts.uncheckedCast(this.value());
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("getterFacet", this.getterFacet);
        attributeMap.put("collectionAddToFacet", this.collectionAddToFacet);
    }
}

