/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.layout;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleConfiguration;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacetAsConfigured;

public class PromptStyleFacetForActionLayoutAnnotation
extends PromptStyleFacetAbstract {
    private final PromptStyle promptStyle;

    public PromptStyleFacetForActionLayoutAnnotation(PromptStyle promptStyle, FacetHolder holder) {
        super(holder);
        this.promptStyle = promptStyle;
    }

    public static PromptStyleFacet create(List<ActionLayout> actionLayouts, IsisConfiguration configuration, FacetHolder holder) {
        return actionLayouts.stream().map(ActionLayout::promptStyle).filter(promptStyle -> promptStyle != PromptStyle.NOT_SPECIFIED).findFirst().map(promptStyle -> {
            switch (promptStyle) {
                case DIALOG: 
                case DIALOG_MODAL: 
                case DIALOG_SIDEBAR: 
                case INLINE: 
                case INLINE_AS_IF_EDIT: {
                    return new PromptStyleFacetForActionLayoutAnnotation((PromptStyle)promptStyle, holder);
                }
                case AS_CONFIGURED: {
                    if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
                        return null;
                    }
                    promptStyle = PromptStyleConfiguration.parse(configuration);
                    return new PromptStyleFacetAsConfigured((PromptStyle)promptStyle, holder);
                }
            }
            throw new IllegalStateException("promptStyle '" + promptStyle + "' not recognised");
        }).orElseGet(() -> {
            if (holder.containsDoOpFacet(PromptStyleFacet.class)) {
                return null;
            }
            PromptStyle promptStyle = PromptStyleConfiguration.parse(configuration);
            return new PromptStyleFacetAsConfigured(promptStyle, holder);
        });
    }

    @Override
    public PromptStyle value() {
        return this.promptStyle;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("promptStyle", this.promptStyle);
    }
}

