/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.layout;

import java.util.List;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.layout.ActionPositionFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.BookmarkPolicyFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFaFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.DescribedAsFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.HiddenFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.NamedFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.NotContributedFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.PromptStyleFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.RedirectFacetFromActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.notcontributed.NotContributedFacet;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacetFallback;
import org.apache.isis.core.metamodel.facets.actions.redirect.RedirectFacet;
import org.apache.isis.core.metamodel.facets.actions.redirect.RedirectFacetFallback;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.promptStyle.PromptStyleFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ActionLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public ActionLayoutFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Object holder = processMethodContext.getFacetHolder();
        List<ActionLayout> actionLayouts = Annotations.getAnnotations(processMethodContext.getMethod(), ActionLayout.class);
        BookmarkPolicyFacet bookmarkableFacet = BookmarkPolicyFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        FacetUtil.addFacet(bookmarkableFacet);
        CssClassFacet cssClassFacet = CssClassFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        FacetUtil.addFacet(cssClassFacet);
        CssClassFaFacet cssClassFaFacet = CssClassFaFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        FacetUtil.addFacet(cssClassFaFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        FacetUtil.addFacet(hiddenFacet);
        NamedFacet namedFacet = NamedFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        FacetUtil.addFacet(namedFacet);
        PromptStyleFacet promptStyleFacet = PromptStyleFacetForActionLayoutAnnotation.create(actionLayouts, this.getConfiguration(), holder);
        FacetUtil.addFacet(promptStyleFacet);
        ActionPositionFacet actionPositionFacet = ActionPositionFacetForActionLayoutAnnotation.create(actionLayouts, holder);
        if (actionPositionFacet == null) {
            actionPositionFacet = new ActionPositionFacetFallback((FacetHolder)holder);
        }
        FacetUtil.addFacet(actionPositionFacet);
        RedirectFacet redirectFacet = RedirectFacetFromActionLayoutAnnotation.create(actionLayouts, holder);
        if (redirectFacet == null) {
            redirectFacet = new RedirectFacetFallback((FacetHolder)holder);
        }
        FacetUtil.addFacet(redirectFacet);
        if (this.isContributingServiceOrMixinObject(processMethodContext)) {
            NotContributedFacet notContributedFacet = NotContributedFacetForActionLayoutAnnotation.create(actionLayouts, holder);
            FacetUtil.addFacet(notContributedFacet);
        }
    }

    private boolean isContributingServiceOrMixinObject(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(cls);
        return ActionLayoutFacetFactory.isContributingService(spec) || ActionLayoutFacetFactory.isMixinObject(spec);
    }

    private static boolean isContributingService(ObjectSpecification spec) {
        DomainServiceFacet domainServiceFacet = spec.getFacet(DomainServiceFacet.class);
        return domainServiceFacet != null && !domainServiceFacet.isNoop() && domainServiceFacet.getNatureOfService() != NatureOfService.VIEW_MENU_ONLY && domainServiceFacet.getNatureOfService() != NatureOfService.DOMAIN;
    }

    private static boolean isMixinObject(ObjectSpecification spec) {
        MixinFacet mixinFacet = spec.getFacet(MixinFacet.class);
        boolean b = mixinFacet != null && !mixinFacet.isNoop();
        return b;
    }

    protected boolean skipContributing(DomainServiceFacet domainServiceFacet) {
        return domainServiceFacet == null || domainServiceFacet.isNoop() || domainServiceFacet.getNatureOfService() == NatureOfService.VIEW_MENU_ONLY || domainServiceFacet.getNatureOfService() == NatureOfService.DOMAIN;
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Object holder = processMemberContext.getFacetHolder();
        Facet cssClassFacet = null;
        FacetUtil.addFacet(cssClassFacet);
        Facet cssClassFaFacet = null;
        FacetUtil.addFacet(cssClassFaFacet);
        Facet describedAsFacet = null;
        FacetUtil.addFacet(describedAsFacet);
        MultiTypedFacet hiddenFacet = null;
        FacetUtil.addFacet(hiddenFacet);
        Facet namedFacet = null;
        FacetUtil.addFacet(namedFacet);
        ActionPositionFacetFallback actionPositionFacet = null;
        if (!holder.containsDoOpFacet(ActionPositionFacet.class)) {
            actionPositionFacet = new ActionPositionFacetFallback((FacetHolder)holder);
        }
        FacetUtil.addFacet(actionPositionFacet);
    }
}

