/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.events.domain.ActionDomainEvent;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.applib.services.xactn.TransactionState;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.commons.lang.MethodInvocationPreprocessor;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ixn.InteractionDtoServiceInternal;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;
import org.apache.isis.schema.ixn.v1.ActionInvocationDto;
import org.apache.isis.schema.ixn.v1.MemberExecutionDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionInvocationFacetForDomainEventAbstract
extends ActionInvocationFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = LoggerFactory.getLogger(ActionInvocationFacetForDomainEventAbstract.class);
    private final Method method;
    private final ObjectSpecification onType;
    private final ObjectSpecification returnType;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ServicesInjector servicesInjector;
    private final IsisConfiguration configuration;
    private final Class<? extends ActionDomainEvent<?>> eventType;
    private final DomainEventHelper domainEventHelper;

    public ActionInvocationFacetForDomainEventAbstract(Class<? extends ActionDomainEvent<?>> eventType, Method method, ObjectSpecification onType, ObjectSpecification returnType, FacetHolder holder, ServicesInjector servicesInjector) {
        super(holder);
        this.eventType = eventType;
        this.method = method;
        this.onType = onType;
        this.returnType = returnType;
        this.authenticationSessionProvider = servicesInjector.getAuthenticationSessionProvider();
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
        this.servicesInjector = servicesInjector;
        this.configuration = _Config.getConfiguration();
        this.domainEventHelper = new DomainEventHelper(this.servicesInjector);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.EXECUTE;
    }

    @Override
    public ObjectSpecification getReturnType() {
        return this.returnType;
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.onType;
    }

    @Override
    public ObjectAdapter invoke(ObjectAction owningAction, ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, ObjectAdapter[] argumentAdapters, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter holder = this.getPersistenceSessionServiceInternal().executeWithinTransaction(() -> this.doInvoke(owningAction, targetAdapter, mixedInAdapter, argumentAdapters, interactionInitiatedBy));
        return holder;
    }

    ObjectAdapter doInvoke(final ObjectAction owningAction, final ObjectAdapter targetAdapter, final ObjectAdapter mixedInAdapter, final ObjectAdapter[] argumentAdapters, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter returnedAdapter;
        CommandContext commandContext = this.getCommandContext();
        final Command command = commandContext.getCommand();
        InteractionContext interactionContext = this.getInteractionContext();
        Interaction interaction = interactionContext.getInteraction();
        String actionId = owningAction.getIdentifier().toClassAndNameIdentityString();
        if (command.getExecutor() == Command.Executor.USER && command.getExecuteIn() == CommandExecuteIn.BACKGROUND) {
            CommandService commandService = this.getCommandService();
            if (!commandService.persistIfPossible(command)) {
                throw new IsisException(String.format("Unable to persist command for action '%s'; CommandService does not support persistent commands ", actionId));
            }
            returnedAdapter = this.getObjectAdapterProvider().adapterFor(command);
        } else {
            final ObjectAdapter mixinElseRegularAdapter = mixedInAdapter != null ? mixedInAdapter : targetAdapter;
            Object mixinElseRegularPojo = ObjectAdapter.Util.unwrapPojo(mixinElseRegularAdapter);
            final List<ObjectAdapter> argumentAdapterList = Arrays.asList(argumentAdapters);
            List<Object> argumentPojos = ObjectAdapter.Util.unwrapPojoList(argumentAdapterList);
            String targetMember = ActionInvocationFacetForDomainEventAbstract.targetNameFor(owningAction, mixedInAdapter);
            String targetClass = CommandUtil.targetClassNameFor(mixinElseRegularAdapter);
            final Interaction.ActionInvocation execution = new Interaction.ActionInvocation(interaction, actionId, mixinElseRegularPojo, argumentPojos, targetMember, targetClass);
            Interaction.MemberExecutor<Interaction.ActionInvocation> callable = new Interaction.MemberExecutor<Interaction.ActionInvocation>(){

                public Object execute(Interaction.ActionInvocation currentExecution) {
                    try {
                        ActionInvocationDto invocationDto = ActionInvocationFacetForDomainEventAbstract.this.getInteractionDtoServiceInternal().asActionInvocationDto(owningAction, mixinElseRegularAdapter, argumentAdapterList);
                        currentExecution.setDto((MemberExecutionDto)invocationDto);
                        Timestamp startedAt = ActionInvocationFacetForDomainEventAbstract.this.getClockService().nowAsJavaSqlTimestamp();
                        execution.setStartedAt(startedAt);
                        if (command.getStartedAt() == null) {
                            command.internal().setStartedAt(startedAt);
                        }
                        ActionDomainEvent event = ActionInvocationFacetForDomainEventAbstract.this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.EXECUTING, ActionInvocationFacetForDomainEventAbstract.this.getEventType(), null, owningAction, owningAction, targetAdapter, mixedInAdapter, argumentAdapters, command, null);
                        currentExecution.setEvent(event);
                        Object resultPojo = ActionInvocationFacetForDomainEventAbstract.this.invokeMethodElseFromCache(targetAdapter, argumentAdapters);
                        ObjectAdapter resultAdapterPossiblyCloned = ActionInvocationFacetForDomainEventAbstract.this.cloneIfViewModelCloneable(resultPojo, mixinElseRegularAdapter);
                        ActionInvocationFacetForDomainEventAbstract.this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.EXECUTED, ActionInvocationFacetForDomainEventAbstract.this.getEventType(), event, owningAction, owningAction, targetAdapter, mixedInAdapter, argumentAdapters, command, resultAdapterPossiblyCloned);
                        return ObjectAdapter.Util.unwrapPojo(resultAdapterPossiblyCloned);
                    }
                    catch (Exception e) {
                        Consumer<RecoverableException> recovery = recoverableException -> {
                            if (!ActionInvocationFacetForDomainEventAbstract.this.getTransactionState().canCommit()) {
                                Throwable recoverableExceptionCause = recoverableException.getCause();
                                Throwable nonRecoverableCause = recoverableExceptionCause != null ? recoverableExceptionCause : recoverableException;
                                String message = ActionInvocationFacetForDomainEventAbstract.trim(nonRecoverableCause.getMessage(), 300);
                                throw new NonRecoverableException(message, nonRecoverableCause);
                            }
                        };
                        return ThrowableExtensions.handleInvocationException(e, ActionInvocationFacetForDomainEventAbstract.this.method.getName(), recovery);
                    }
                }
            };
            interaction.execute((Interaction.MemberExecutor)callable, execution);
            Interaction.Execution priorExecution = (Interaction.Execution)_Casts.uncheckedCast((Object)interaction.getPriorExecution());
            Exception executionExceptionIfAny = priorExecution.getThrew();
            if (executionExceptionIfAny != null) {
                throw executionExceptionIfAny instanceof RuntimeException ? (RuntimeException)executionExceptionIfAny : new RuntimeException(executionExceptionIfAny);
            }
            Object returnedPojo = priorExecution.getReturned();
            returnedAdapter = this.getObjectAdapterProvider().adapterFor(returnedPojo);
            this.getInteractionDtoServiceInternal().updateResult((ActionInvocationDto)priorExecution.getDto(), owningAction, returnedPojo);
            this.setCommandResultIfEntity(command, returnedAdapter);
            PublishedActionFacet publishedActionFacet = this.getIdentified().getFacet(PublishedActionFacet.class);
            if (publishedActionFacet != null) {
                this.getPublishingServiceInternal().publishAction(priorExecution);
            }
        }
        return this.filteredIfRequired(returnedAdapter, interactionInitiatedBy);
    }

    private static String targetNameFor(ObjectAction owningAction, ObjectAdapter mixedInAdapter) {
        return ObjectAction.Util.targetNameFor(owningAction, mixedInAdapter).orElseGet(() -> CommandUtil.targetMemberNameFor(owningAction));
    }

    private static String trim(String message, int maxLen) {
        if (!_Strings.isNullOrEmpty((CharSequence)message) && (message = message.substring(0, Math.min(message.length(), maxLen))).length() == maxLen) {
            message = message + " ...";
        }
        return message;
    }

    protected Object invokeMethodElseFromCache(ObjectAdapter targetAdapter, ObjectAdapter[] arguments) throws IllegalAccessException, InvocationTargetException {
        boolean cacheable;
        Object[] executionParameters = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            executionParameters[i] = ActionInvocationFacetForDomainEventAbstract.unwrap(arguments[i]);
        }
        Object targetPojo = ActionInvocationFacetForDomainEventAbstract.unwrap(targetAdapter);
        ActionSemanticsFacet semanticsFacet = this.getFacetHolder().getFacet(ActionSemanticsFacet.class);
        boolean bl = cacheable = semanticsFacet != null && ((SemanticsOf)semanticsFacet.value()).isSafeAndRequestCacheable();
        if (cacheable) {
            QueryResultsCache queryResultsCache = this.getQueryResultsCache();
            Object[] targetPojoPlusExecutionParameters = ArrayExtensions.appendT(executionParameters, targetPojo);
            return queryResultsCache.execute(() -> MethodInvocationPreprocessor.invoke(this.method, targetPojo, executionParameters), targetPojo.getClass(), this.method.getName(), targetPojoPlusExecutionParameters);
        }
        return MethodInvocationPreprocessor.invoke(this.method, targetPojo, executionParameters);
    }

    protected ObjectAdapter cloneIfViewModelCloneable(Object resultPojo, ObjectAdapter targetAdapter) {
        if (resultPojo != null) {
            ObjectAdapter resultAdapter = this.getObjectAdapterProvider().adapterFor(resultPojo);
            return this.cloneIfViewModelElse(resultAdapter, resultAdapter);
        }
        return this.cloneIfViewModelElse(targetAdapter, null);
    }

    private ObjectAdapter cloneIfViewModelElse(ObjectAdapter adapter, ObjectAdapter dfltAdapter) {
        if (!adapter.getSpecification().isViewModelCloneable(adapter)) {
            return dfltAdapter;
        }
        ViewModelFacet viewModelFacet = adapter.getSpecification().getFacet(ViewModelFacet.class);
        Object clone = viewModelFacet.clone(adapter.getPojo());
        ObjectAdapter clonedAdapter = this.getObjectAdapterProvider().adapterFor(clone);
        return clonedAdapter;
    }

    protected void setCommandResultIfEntity(Command command, ObjectAdapter resultAdapter) {
        if (command.getResult() != null) {
            return;
        }
        if (resultAdapter == null) {
            return;
        }
        Class<?> domainType = resultAdapter.getSpecification().getCorrespondingClass();
        MetaModelService.Sort sort = this.getMetaModelService().sortOf(domainType, MetaModelService.Mode.STRICT);
        switch (sort) {
            case JDO_ENTITY: {
                Object domainObject = resultAdapter.getPojo();
                if (!this.getRepositoryService().isPersistent(domainObject)) {
                    this.getTransactionService().flushTransaction();
                }
                if (!this.getRepositoryService().isPersistent(domainObject)) break;
                BookmarkService bookmarkService = this.getBookmarkService();
                Bookmark bookmark = bookmarkService.bookmarkFor(domainObject);
                command.internal().setResult(bookmark);
                break;
            }
        }
    }

    private MetaModelService getMetaModelService() {
        return (MetaModelService)this.servicesInjector.lookupServiceElseFail(MetaModelService.class);
    }

    private TransactionService getTransactionService() {
        return (TransactionService)this.servicesInjector.lookupServiceElseFail(TransactionService.class);
    }

    private BookmarkService getBookmarkService() {
        return (BookmarkService)this.servicesInjector.lookupServiceElseFail(BookmarkService.class);
    }

    private RepositoryService getRepositoryService() {
        return (RepositoryService)this.servicesInjector.lookupServiceElseFail(RepositoryService.class);
    }

    protected ObjectAdapter filteredIfRequired(ObjectAdapter resultAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        if (resultAdapter == null) {
            return null;
        }
        boolean filterForVisibility = this.getConfiguration().getBoolean("isis.reflector.facet.filterVisibility", true);
        if (!filterForVisibility) {
            return resultAdapter;
        }
        Object result = resultAdapter.getPojo();
        if (result instanceof Collection || result.getClass().isArray()) {
            Stream<ObjectAdapter> adapters = CollectionFacet.Utils.streamAdapters(resultAdapter);
            List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(adapters, interactionInitiatedBy);
            Object visibleObjects = CollectionUtils.copyOf(_NullSafe.stream(visibleAdapters).map(ObjectAdapter.Util::unwrapPojo).collect(Collectors.toList()), this.method.getReturnType());
            if (visibleObjects != null) {
                return this.getObjectAdapterProvider().adapterFor(visibleObjects);
            }
            return resultAdapter;
        }
        boolean visible = ObjectAdapter.Util.isVisible(resultAdapter, interactionInitiatedBy);
        return visible ? resultAdapter : null;
    }

    public <S> Class<? extends ActionDomainEvent<S>> getEventType() {
        return (Class)_Casts.uncheckedCast(this.eventType);
    }

    private static Object unwrap(ObjectAdapter adapter) {
        return adapter == null ? null : adapter.getPojo();
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private CommandContext getCommandContext() {
        return (CommandContext)this.servicesInjector.lookupServiceElseFail(CommandContext.class);
    }

    private InteractionContext getInteractionContext() {
        return (InteractionContext)this.servicesInjector.lookupServiceElseFail(InteractionContext.class);
    }

    private QueryResultsCache getQueryResultsCache() {
        return (QueryResultsCache)this.servicesInjector.lookupServiceElseFail(QueryResultsCache.class);
    }

    private CommandService getCommandService() {
        return (CommandService)this.servicesInjector.lookupServiceElseFail(CommandService.class);
    }

    private ClockService getClockService() {
        return (ClockService)this.servicesInjector.lookupServiceElseFail(ClockService.class);
    }

    private PublishingServiceInternal getPublishingServiceInternal() {
        return (PublishingServiceInternal)this.servicesInjector.lookupServiceElseFail(PublishingServiceInternal.class);
    }

    private InteractionDtoServiceInternal getInteractionDtoServiceInternal() {
        return (InteractionDtoServiceInternal)this.servicesInjector.lookupServiceElseFail(InteractionDtoServiceInternal.class);
    }

    private ObjectAdapterProvider getObjectAdapterProvider() {
        return this.persistenceSessionServiceInternal;
    }

    private PersistenceSessionServiceInternal getPersistenceSessionServiceInternal() {
        return this.persistenceSessionServiceInternal;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    public TransactionState getTransactionState() {
        return this.persistenceSessionServiceInternal.getTransactionState();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
        attributeMap.put("onType", this.onType);
        attributeMap.put("returnType", this.returnType);
        attributeMap.put("eventType", this.eventType);
    }
}

