/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.applib.events.domain.ActionDomainEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.wrapper.events.InteractionEvent;
import org.apache.isis.applib.services.wrapper.events.UsabilityEvent;
import org.apache.isis.applib.services.wrapper.events.ValidityEvent;
import org.apache.isis.applib.services.wrapper.events.VisibilityEvent;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Tuples;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacet;
import org.apache.isis.core.metamodel.interactions.ActionInteractionContext;
import org.apache.isis.core.metamodel.interactions.ActionValidityContext;
import org.apache.isis.core.metamodel.interactions.InteractionContext;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public abstract class ActionDomainEventFacetAbstract
extends SingleClassValueFacetAbstract
implements ActionDomainEventFacet {
    private Class<? extends ActionDomainEvent<?>> eventType;
    private final TranslationService translationService;
    private final String translationContext;
    private final DomainEventHelper domainEventHelper;

    static Class<? extends Facet> type() {
        return ActionDomainEventFacet.class;
    }

    public ActionDomainEventFacetAbstract(Class<? extends ActionDomainEvent<?>> eventType, FacetHolder holder, ServicesInjector servicesInjector, SpecificationLoader specificationLoader) {
        super(ActionDomainEventFacetAbstract.type(), holder, eventType, specificationLoader);
        this.eventType = eventType;
        this.translationService = servicesInjector.lookupService(TranslationService.class).orElse(null);
        this.translationContext = ((IdentifiedHolder)holder).getIdentifier().toClassAndNameIdentityString();
        this.domainEventHelper = new DomainEventHelper(servicesInjector);
    }

    @Override
    public Class<?> value() {
        return this.eventType;
    }

    protected Class eventType() {
        return this.eventType;
    }

    public <S> Class<? extends ActionDomainEvent<S>> getEventType() {
        return (Class)_Casts.uncheckedCast(this.eventType);
    }

    public void setEventType(Class<? extends ActionDomainEvent<?>> eventType) {
        this.eventType = eventType;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        ActionDomainEvent event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.HIDE, this.getEventType(), null, ActionDomainEventFacetAbstract.actionFrom(ic), this.getIdentified(), ic.getTarget(), ic.getMixedIn(), ActionDomainEventFacetAbstract.argumentAdaptersFrom(ic), null, null);
        if (event != null && event.isHidden()) {
            return "Hidden by subscriber";
        }
        return null;
    }

    @Override
    public String disables(UsabilityContext<? extends UsabilityEvent> ic) {
        ActionDomainEvent event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.DISABLE, this.getEventType(), null, ActionDomainEventFacetAbstract.actionFrom(ic), this.getIdentified(), ic.getTarget(), ic.getMixedIn(), ActionDomainEventFacetAbstract.argumentAdaptersFrom(ic), null, null);
        if (event != null && event.isDisabled()) {
            TranslatableString reasonTranslatable = event.getDisabledReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getDisabledReason();
        }
        return null;
    }

    private static ObjectAction actionFrom(InteractionContext<?> ic) {
        if (!(ic instanceof ActionInteractionContext)) {
            throw new IllegalStateException("Expecting ic to be of type ActionInteractionContext, instead was: " + ic);
        }
        return ((ActionInteractionContext)((Object)ic)).getObjectAction();
    }

    private static ManagedObject[] argumentAdaptersFrom(InteractionContext<? extends InteractionEvent> ic) {
        _Tuples.Tuple2<Integer, ManagedObject> contributee = ic.getContributeeWithParamIndex();
        if (contributee != null) {
            int paramIndex = (Integer)contributee.get_1();
            ManagedObject adapter = (ManagedObject)contributee.get_2();
            return new ManagedObject[]{paramIndex == 0 ? adapter : null};
        }
        return null;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> ic) {
        ActionValidityContext aic = (ActionValidityContext)ic;
        ActionDomainEvent event = this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.VALIDATE, this.getEventType(), null, ActionDomainEventFacetAbstract.actionFrom(ic), this.getIdentified(), ic.getTarget(), ic.getMixedIn(), aic.getArgs(), null, null);
        if (event != null && event.isInvalid()) {
            TranslatableString reasonTranslatable = event.getInvalidityReasonTranslatable();
            if (reasonTranslatable != null) {
                return reasonTranslatable.translate(this.translationService, this.translationContext);
            }
            return event.getInvalidityReason();
        }
        return null;
    }
}

