/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactory;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public abstract class MethodPrefixBasedFacetFactoryAbstract
extends FacetFactoryAbstract
implements MethodPrefixBasedFacetFactory {
    public static final String ISIS_REFLECTOR_VALIDATOR_NO_PARAMS_ONLY_KEY = "isis.reflector.validator.noParamsOnly";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_NO_PARAMS_ONLY_DEFAULT = false;
    private final List<String> prefixes;
    protected static final Class<?>[] NO_PARAMETERS_TYPES = new Class[0];
    private final OrphanValidation orphanValidation;

    public MethodPrefixBasedFacetFactoryAbstract(List<FeatureType> featureTypes, OrphanValidation orphanValidation, String ... prefixes) {
        super(featureTypes);
        this.orphanValidation = orphanValidation;
        this.prefixes = Collections.unmodifiableList(Arrays.asList(prefixes));
    }

    @Override
    public List<String> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        if (this.orphanValidation == OrphanValidation.DONT_VALIDATE) {
            return;
        }
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                boolean noParamsOnly = _Config.getConfiguration().getBoolean(MethodPrefixBasedFacetFactoryAbstract.ISIS_REFLECTOR_VALIDATOR_NO_PARAMS_ONLY_KEY, false);
                Stream<ObjectAction> objectActions = objectSpec.streamObjectActions(Contributed.EXCLUDED);
                objectActions.forEach(objectAction -> {
                    for (String prefix : MethodPrefixBasedFacetFactoryAbstract.this.prefixes) {
                        String actionId = objectAction.getId();
                        if (!actionId.startsWith(prefix) || prefix.length() >= actionId.length()) continue;
                        String explanation = objectAction.getParameterCount() > 0 && noParamsOnly && (Objects.equals(prefix, "hide") || Objects.equals(prefix, "disable")) ? " (note that such methods must have no parameters, 'isis.reflector.validator.noParamsOnly' config property)" : "";
                        String message = "%s#%s: has prefix %s, is probably intended as a supporting method for a property, collection or action%s.  If the method is intended to be an action, then rename and use @ActionLayout(named=\"...\") or ignore completely using @Programmatic";
                        validationFailures.add("%s#%s: has prefix %s, is probably intended as a supporting method for a property, collection or action%s.  If the method is intended to be an action, then rename and use @ActionLayout(named=\"...\") or ignore completely using @Programmatic", objectSpec.getIdentifier().getClassName(), actionId, prefix, explanation);
                    }
                });
                return true;
            }
        }));
    }

    protected static enum OrphanValidation {
        VALIDATE,
        DONT_VALIDATE;

    }
}

