/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.TypedHolderDefault;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemanticsFacetDefault;
import org.apache.isis.core.metamodel.specloader.CollectionUtils;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class FacetedMethod
extends TypedHolderDefault
implements IdentifiedHolder {
    private final Class<?> owningType;
    private final Method method;
    private final Identifier identifier;
    private final List<FacetedMethodParameter> parameters;

    public static FacetedMethod createForProperty(Class<?> declaringType, String propertyName) {
        try {
            Method method = declaringType.getMethod("get" + StringExtensions.asPascal(propertyName), new Class[0]);
            return FacetedMethod.createForProperty(declaringType, method);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static FacetedMethod createForCollection(Class<?> declaringType, String collectionName) {
        try {
            Method method = declaringType.getMethod("get" + StringExtensions.asPascal(collectionName), new Class[0]);
            return FacetedMethod.createForCollection(declaringType, method);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static FacetedMethod createForAction(Class<?> declaringType, String actionName, SpecificationLoader specificationLoader, Class<?> ... parameterTypes) {
        try {
            Method method = declaringType.getMethod(actionName, parameterTypes);
            return FacetedMethod.createForAction(declaringType, method, specificationLoader);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static FacetedMethod createForProperty(Class<?> declaringType, Method method) {
        return new FacetedMethod(FeatureType.PROPERTY, declaringType, method, method.getReturnType(), FacetedMethod.emptyParameterList());
    }

    public static FacetedMethod createForCollection(Class<?> declaringType, Method method) {
        return new FacetedMethod(FeatureType.COLLECTION, declaringType, method, null, FacetedMethod.emptyParameterList());
    }

    public static FacetedMethod createForAction(Class<?> declaringType, Method method, SpecificationLoader specificationLoader) {
        return new FacetedMethod(FeatureType.ACTION, declaringType, method, method.getReturnType(), FacetedMethod.getParameters(declaringType, method, specificationLoader));
    }

    private static List<FacetedMethodParameter> getParameters(Class<?> declaringType, Method actionMethod, SpecificationLoader specificationLoader) {
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        Type[] genericParameterTypes = actionMethod.getGenericParameterTypes();
        ArrayList actionParams = _Lists.newArrayList();
        for (int paramNum = 0; paramNum < parameterTypes.length; ++paramNum) {
            Class<?> parameterType = parameterTypes[paramNum];
            Type genericParameterType = genericParameterTypes[paramNum];
            FeatureType featureType = CollectionUtils.isParamCollection(parameterType, genericParameterType) ? FeatureType.ACTION_PARAMETER_COLLECTION : FeatureType.ACTION_PARAMETER_SCALAR;
            FacetedMethodParameter fmp = new FacetedMethodParameter(featureType, declaringType, actionMethod, parameterType);
            actionParams.add(fmp);
            if (featureType != FeatureType.ACTION_PARAMETER_COLLECTION) continue;
            CollectionSemanticsFacet semanticsFacet = CollectionSemanticsFacetDefault.forParamType(parameterType, fmp);
            FacetUtil.addFacet(semanticsFacet);
            TypeOfFacet typeOfFacet = TypeOfFacet.Util.inferFromGenericParamType(fmp, parameterType, genericParameterType, specificationLoader);
            if (typeOfFacet == null && _Arrays.isArrayType(parameterType)) {
                typeOfFacet = TypeOfFacet.Util.inferFromArrayType(fmp, parameterType, specificationLoader);
            }
            if (typeOfFacet == null) continue;
            FacetUtil.addFacet(typeOfFacet);
            fmp.setType(typeOfFacet.value());
        }
        return Collections.unmodifiableList(actionParams);
    }

    public List<FacetedMethodParameter> getParameters() {
        return this.parameters;
    }

    public static List<FacetedMethodParameter> emptyParameterList() {
        List emptyList = Collections.emptyList();
        return Collections.unmodifiableList(emptyList);
    }

    private FacetedMethod(FeatureType featureType, Class<?> declaringType, Method method, Class<?> type, List<FacetedMethodParameter> parameters) {
        super(featureType, type);
        this.owningType = declaringType;
        this.method = method;
        this.identifier = featureType.identifierFor(declaringType, method);
        this.parameters = parameters;
    }

    public Class<?> getOwningType() {
        return this.owningType;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getFeatureType().name() + " Peer [identifier=\"" + this.getIdentifier() + "\",type=" + this.getType().getName() + " ]";
    }
}

