/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;

public class FacetHolderImpl
implements FacetHolder {
    private final Map<Class<? extends Facet>, Facet> facetsByClass = new HashMap<Class<? extends Facet>, Facet>();

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.facetsByClass.containsKey(facetType);
    }

    @Override
    public boolean containsDoOpFacet(Class<? extends Facet> facetType) {
        Facet facet = this.getFacet(facetType);
        return facet != null && !facet.isNoop();
    }

    @Override
    public boolean containsDoOpNotDerivedFacet(Class<? extends Facet> facetType) {
        Facet facet = this.getFacet(facetType);
        return facet != null && !facet.isNoop() && !facet.isDerived();
    }

    @Override
    public void addFacet(Facet facet) {
        this.addFacet(facet.facetType(), facet);
    }

    @Override
    public void addFacet(MultiTypedFacet mtFacet) {
        mtFacet.facetTypes().forEach(facetType -> this.addFacet((Class<? extends Facet>)facetType, (Facet)mtFacet.getFacet(facetType)));
    }

    private void addFacet(Class<? extends Facet> facetType, Facet facet) {
        Facet existingFacet = this.getFacet(facetType);
        if (existingFacet == null || existingFacet.isNoop()) {
            this.facetsByClass.put(facetType, facet);
            return;
        }
        if (!facet.alwaysReplace()) {
            return;
        }
        if (facet.isDerived() && !existingFacet.isDerived()) {
            return;
        }
        facet.setUnderlyingFacet(existingFacet);
        this.facetsByClass.put(facetType, facet);
    }

    @Override
    public void removeFacet(Facet facet) {
        FacetUtil.removeFacet(this.facetsByClass, facet);
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        FacetUtil.removeFacet(this.facetsByClass, facetType);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facetType) {
        return (T)((Facet)_Casts.uncheckedCast((Object)this.facetsByClass.get(facetType)));
    }

    @Override
    public Stream<Facet> streamFacets() {
        return this.facetsByClass.values().stream().distinct();
    }

    @Override
    public int getFacetCount() {
        return this.facetsByClass.size();
    }
}

