/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;

public abstract class FacetAbstract
implements Facet {
    private Facet underlyingFacet;
    private final Class<? extends Facet> facetType;
    private final boolean derived;
    private FacetHolder holder;
    private IdentifiedHolder identifiedHolder;

    public FacetAbstract(Class<? extends Facet> facetType, FacetHolder holder, Derivation derivation) {
        this.facetType = (Class)_With.requires(facetType, (String)"facetType");
        this.setFacetHolder((FacetHolder)_With.requires((Object)holder, (String)"holder"));
        this.derived = derivation == Derivation.DERIVED;
    }

    @Override
    public final Class<? extends Facet> facetType() {
        return this.facetType;
    }

    @Override
    public FacetHolder getFacetHolder() {
        return this.holder;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    public IdentifiedHolder getIdentified() {
        return this.identifiedHolder;
    }

    @Override
    public Facet getUnderlyingFacet() {
        return this.underlyingFacet;
    }

    @Override
    public void setUnderlyingFacet(Facet underlyingFacet) {
        if (underlyingFacet != null) {
            if (underlyingFacet instanceof MultiTypedFacet) {
                MultiTypedFacet multiTypedFacet = (MultiTypedFacet)underlyingFacet;
                boolean matches = this.compatible(multiTypedFacet);
                if (!matches) {
                    throw new IllegalArgumentException("illegal argument, expected underlying facet (a multi-valued facet) to have equivalent to the facet type (or facet types) of this facet");
                }
            } else {
                Ensure.ensureThatArg(underlyingFacet.facetType(), type -> Objects.equals(type, this.facetType), () -> String.format("type-missmatch: underlying facet's type '%s' must match this facet's type '%s'", new Object[0]));
            }
        }
        this.underlyingFacet = underlyingFacet;
    }

    private boolean compatible(MultiTypedFacet multiTypedFacet) {
        if (!(this instanceof MultiTypedFacet)) {
            return multiTypedFacet.containsFacetTypeOf(this.facetType);
        }
        MultiTypedFacet thisAsMultiTyped = (MultiTypedFacet)((Object)this);
        Stream<Class<? extends Facet>> facetTypes = thisAsMultiTyped.facetTypes();
        return facetTypes.anyMatch(facetType -> multiTypedFacet.containsFacetTypeOf((Class<? extends Facet>)facetType));
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public boolean alwaysReplace() {
        return true;
    }

    @Override
    public void setFacetHolder(FacetHolder facetHolder) {
        this.holder = facetHolder;
        this.identifiedHolder = this.holder instanceof IdentifiedHolder ? (IdentifiedHolder)this.holder : null;
    }

    protected String toStringValues() {
        return "";
    }

    public String toString() {
        String details = "";
        if (this.isValidating()) {
            details = details + "Validating";
        }
        if (this.isDisabling()) {
            details = details + (details.length() > 0 ? ";" : "") + "Disabling";
        }
        if (this.isHiding()) {
            details = details + (details.length() > 0 ? ";" : "") + "Hiding";
        }
        if (!"".equals(details)) {
            details = "interaction=" + details + ",";
        }
        String className = this.getClass().getName();
        String stringValues = this.toStringValues();
        if (this.getClass() != this.facetType()) {
            String facetType = this.facetType().getName();
            details = details + "type=" + facetType.substring(facetType.lastIndexOf(46) + 1);
        }
        if (!"".equals(stringValues)) {
            details = details + ",";
        }
        return className.substring(className.lastIndexOf(46) + 1) + "[" + details + stringValues + "]";
    }

    private boolean isHiding() {
        return Hiding.class.isAssignableFrom(this.getClass());
    }

    private boolean isDisabling() {
        return Disabling.class.isAssignableFrom(this.getClass());
    }

    private boolean isValidating() {
        return Validating.class.isAssignableFrom(this.getClass());
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        if (this.derived) {
            attributeMap.put("derived", this.derived);
        }
        attributeMap.put("underlyingFacet", this.underlyingFacet);
        if (this.isNoop()) {
            attributeMap.put("noop", this.isNoop());
        }
        if (this.isHiding()) {
            attributeMap.put("hiding", this.isHiding());
        }
        if (this.isDisabling()) {
            attributeMap.put("disabling", this.isDisabling());
        }
        if (this.isValidating()) {
            attributeMap.put("validating", this.isValidating());
        }
    }

    public static interface Validating {
    }

    public static interface Disabling {
    }

    public static interface Hiding {
    }

    public static enum Derivation {
        DERIVED,
        NOT_DERIVED;

    }
}

