/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.consent;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.consent.Allow;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionResult;

public class InteractionResultSet {
    private final List<InteractionResult> results = new ArrayList<InteractionResult>();
    private InteractionResult firstResult = null;

    public InteractionResultSet add(InteractionResult result) {
        if (this.firstResult == null) {
            this.firstResult = result;
        }
        this.results.add(result);
        return this;
    }

    public boolean isAllowed() {
        return !this.isVetoed();
    }

    public boolean isVetoed() {
        for (InteractionResult result : this.results) {
            if (!result.isVetoing()) continue;
            return true;
        }
        return false;
    }

    public Consent createConsent() {
        InteractionResult interactionResult = this.getInteractionResult();
        if (interactionResult == null) {
            return Allow.DEFAULT;
        }
        return interactionResult.createConsent();
    }

    public InteractionResult getInteractionResult() {
        for (InteractionResult result : this.results) {
            if (result.isNotVetoing()) continue;
            return result;
        }
        return this.firstResult != null ? this.firstResult : null;
    }

    public String toString() {
        return super.toString();
    }
}

