/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.schema.common.v1.BookmarkObjectState;
import org.apache.isis.schema.common.v1.OidDto;

enum Oid_State {
    PERSISTENT,
    TRANSIENT,
    VIEWMODEL;


    public boolean isTransient() {
        return this == TRANSIENT;
    }

    public boolean isViewModel() {
        return this == VIEWMODEL;
    }

    public boolean isPersistent() {
        return this == PERSISTENT;
    }

    public static Oid_State from(Bookmark bookmark) {
        Bookmark.ObjectState objectState = bookmark.getObjectState();
        return Oid_State.from(objectState);
    }

    public static Oid_State from(Bookmark.ObjectState objectState) {
        switch (objectState) {
            case VIEW_MODEL: {
                return VIEWMODEL;
            }
            case TRANSIENT: {
                return TRANSIENT;
            }
            case PERSISTENT: {
                return PERSISTENT;
            }
        }
        throw _Exceptions.unmatchedCase((Object)objectState);
    }

    public Bookmark.ObjectState asBookmarkObjectState() {
        switch (this) {
            case VIEWMODEL: {
                return Bookmark.ObjectState.VIEW_MODEL;
            }
            case TRANSIENT: {
                return Bookmark.ObjectState.TRANSIENT;
            }
            case PERSISTENT: {
                return Bookmark.ObjectState.PERSISTENT;
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)this));
    }

    public Bookmark bookmarkOf(RootOid rootOid) {
        String objectType = this.asBookmarkObjectState().getCode() + rootOid.getObjectSpecId().asString();
        String identifier = rootOid.getIdentifier();
        return new Bookmark(objectType, identifier);
    }

    public OidDto toOidDto(RootOid rootOid) {
        OidDto oidDto = new OidDto();
        oidDto.setType(rootOid.getObjectSpecId().asString());
        oidDto.setId(rootOid.getIdentifier());
        Bookmark.ObjectState objectState = this.asBookmarkObjectState();
        BookmarkObjectState bookmarkState = objectState.toBookmarkState();
        oidDto.setObjectState((BookmarkObjectState)(bookmarkState != BookmarkObjectState.PERSISTENT ? bookmarkState : null));
        return oidDto;
    }
}

