/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.Oid_Parented;
import org.apache.isis.core.metamodel.adapter.oid.Oid_Root;
import org.apache.isis.core.metamodel.adapter.oid.Oid_State;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;

final class Oid_Marshaller
implements Oid.Marshaller,
Oid.Unmarshaller {
    public static final Oid_Marshaller INSTANCE = new Oid_Marshaller();
    public static final String VIEWMODEL_INDICATOR = Bookmark.ObjectState.VIEW_MODEL.getCode();
    private static final String TRANSIENT_INDICATOR = Bookmark.ObjectState.TRANSIENT.getCode();
    private static final String SEPARATOR = ":";
    private static final String SEPARATOR_NESTING = "~";
    private static final String SEPARATOR_PARENTED = "$";
    private static final String SEPARATOR_VERSION = "^";
    private static final String WORD = "[^:~$\\^#]+";
    private static final String DIGITS = "\\d+";
    private static final String WORD_GROUP = "([^:~$\\^#]+)";
    private static final String DIGITS_GROUP = "(\\d+)";
    private static Pattern OIDSTR_PATTERN = Pattern.compile("^((([" + TRANSIENT_INDICATOR + VIEWMODEL_INDICATOR + "])?" + "([^:~$\\^#]+)" + ":" + "([^:~$\\^#]+)" + ")((" + "~" + "[^:~$\\^#]+" + ":" + "[^:~$\\^#]+" + ")*))([" + "$" + "]" + "[^:~$\\^#]+" + ")?([\\" + "^" + "]" + "(\\d+)" + ":" + "([^:~$\\^#]+)" + "?" + ":" + "(\\d+)" + "?)?$");

    private Oid_Marshaller() {
    }

    @Override
    public String joinAsOid(String domainType, String instanceId) {
        return domainType + SEPARATOR + instanceId;
    }

    @Override
    public String splitInstanceId(String oidStr) {
        int indexOfSeperator = oidStr.indexOf(SEPARATOR);
        return indexOfSeperator > 0 ? oidStr.substring(indexOfSeperator + 1) : null;
    }

    @Override
    public <T extends Oid> T unmarshal(String oidStr, Class<T> requestedType) {
        String collectionPart;
        Matcher matcher = OIDSTR_PATTERN.matcher(oidStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse OID '" + oidStr + "'; should match pattern: " + OIDSTR_PATTERN.pattern());
        }
        String isTransientOrViewModelStr = this.getGroup(matcher, 3);
        Oid_State state = "!".equals(isTransientOrViewModelStr) ? Oid_State.TRANSIENT : ("*".equals(isTransientOrViewModelStr) ? Oid_State.VIEWMODEL : Oid_State.PERSISTENT);
        String rootObjectType = this.getGroup(matcher, 4);
        String rootIdentifier = this.getGroup(matcher, 5);
        String aggregateOidPart = this.getGroup(matcher, 6);
        ArrayList aggregateOidParts = _Lists.newArrayList();
        if (aggregateOidPart != null) {
            Stream tildaSplitted = _Strings.splitThenStream((String)aggregateOidPart, (String)SEPARATOR_NESTING);
            tildaSplitted.forEach(str -> {
                if (_Strings.isNullOrEmpty((CharSequence)str)) {
                    return;
                }
                Iterator colonSplitIter = _Strings.splitThenStream((String)str, (String)SEPARATOR).iterator();
                String objectType = (String)colonSplitIter.next();
                String localId = (String)colonSplitIter.next();
                aggregateOidParts.add(new AggregateOidPart(objectType, localId));
            });
        }
        String collectionName = (collectionPart = this.getGroup(matcher, 8)) != null ? collectionPart.substring(1) : null;
        String versionSequence = this.getGroup(matcher, 10);
        String versionUser = this.getGroup(matcher, 11);
        String versionUtcTimestamp = this.getGroup(matcher, 12);
        Version version = Version.Factory.parse(versionSequence, versionUser, versionUtcTimestamp);
        if (collectionName == null) {
            if (aggregateOidParts.isEmpty()) {
                this.ensureCorrectType(oidStr, requestedType, RootOid.class);
                return (T)((Oid)_Casts.uncheckedCast((Object)Oid_Root.of(ObjectSpecId.of(rootObjectType), rootIdentifier, state, version)));
            }
            throw new RuntimeException("Aggregated Oids are no longer supported");
        }
        String oidStrWithoutCollectionName = this.getGroup(matcher, 1);
        String parentOidStr = oidStrWithoutCollectionName + this.marshal(version);
        RootOid parentOid = this.unmarshal(parentOidStr, RootOid.class);
        this.ensureCorrectType(oidStr, requestedType, ParentedOid.class);
        return (T)((Oid)_Casts.uncheckedCast((Object)Oid_Parented.ofName(parentOid, collectionName)));
    }

    private <T> void ensureCorrectType(String oidStr, Class<T> requestedType, Class<? extends Oid> actualType) {
        if (!requestedType.isAssignableFrom(actualType)) {
            throw new IllegalArgumentException(String.format("OID '%s' was unmarshealled to type '%s' which cannot be assigned to requested type '%s'", oidStr, actualType.getSimpleName(), requestedType.getSimpleName()));
        }
    }

    private String getGroup(Matcher matcher, int group) {
        int groupCount = matcher.groupCount();
        if (group > groupCount) {
            return null;
        }
        String val = matcher.group(group);
        return _Strings.emptyToNull((String)val);
    }

    @Override
    public final String marshal(RootOid rootOid) {
        Ensure.ensure("can not marshal values", !rootOid.isValue());
        return this.marshalNoVersion(rootOid) + this.marshal(rootOid.getVersion());
    }

    @Override
    public final String marshalNoVersion(RootOid rootOid) {
        Ensure.ensure("can not marshal values", !rootOid.isValue());
        String transientIndicator = rootOid.isTransient() ? TRANSIENT_INDICATOR : "";
        String viewModelIndicator = rootOid.isViewModel() ? VIEWMODEL_INDICATOR : "";
        return transientIndicator + viewModelIndicator + rootOid.getObjectSpecId() + SEPARATOR + rootOid.getIdentifier();
    }

    @Override
    public final String marshal(ParentedOid parentedOid) {
        return this.marshalNoVersion(parentedOid) + this.marshal(parentedOid.getVersion());
    }

    @Override
    public String marshalNoVersion(ParentedOid parentedOid) {
        return parentedOid.getParentOid().enStringNoVersion() + SEPARATOR_PARENTED + parentedOid.getName();
    }

    @Override
    public final String marshal(Version version) {
        if (Version.isEmpty(version)) {
            return "";
        }
        String versionUser = version.getUser();
        return SEPARATOR_VERSION + version.getSequence() + SEPARATOR + _Strings.nullToEmpty((String)versionUser) + SEPARATOR + (version.hasTimestamp() ? Long.valueOf(version.getUtcTimestamp()) : "");
    }

    private static class AggregateOidPart {
        String objectType;
        String localId;

        AggregateOidPart(String objectType, String localId) {
            this.objectType = objectType;
            this.localId = localId;
        }

        public String toString() {
            return Oid_Marshaller.SEPARATOR_NESTING + this.objectType + Oid_Marshaller.SEPARATOR + this.localId;
        }
    }
}

