/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.metamodel.adapter.oid.Oid_Marshaller;
import org.apache.isis.core.metamodel.adapter.oid.Oid_Parented;
import org.apache.isis.core.metamodel.adapter.oid.Oid_Root;
import org.apache.isis.core.metamodel.adapter.oid.Oid_State;
import org.apache.isis.core.metamodel.adapter.oid.Oid_Value;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public interface Oid
extends Encodable {
    public String enString();

    public String enStringNoVersion();

    public Version getVersion();

    public void setVersion(Version var1);

    public boolean isTransient();

    public boolean isViewModel();

    public boolean isPersistent();

    default public boolean isValue() {
        return false;
    }

    public static Marshaller marshaller() {
        return Oid_Marshaller.INSTANCE;
    }

    public static Unmarshaller unmarshaller() {
        return Oid_Marshaller.INSTANCE;
    }

    public Oid copy();

    public static final class Factory {
        public static RootOid value() {
            return Oid_Value.INSTANCE;
        }

        public static RootOid ofBookmark(Bookmark bookmark) {
            return Oid_Root.of(ObjectSpecId.of(bookmark.getObjectType()), bookmark.getIdentifier(), Oid_State.from(bookmark), Version.empty());
        }

        public static RootOid viewmodelOf(ObjectSpecId objectSpecId, String mementoStr) {
            return Oid_Root.of(objectSpecId, mementoStr, Oid_State.VIEWMODEL, Version.empty());
        }

        public static RootOid transientOf(ObjectSpecId objectSpecId, String identifier) {
            return Oid_Root.of(objectSpecId, identifier, Oid_State.TRANSIENT, Version.empty());
        }

        public static RootOid persistentOf(ObjectSpecId objectSpecId, String identifier) {
            return Factory.persistentOf(objectSpecId, identifier, null);
        }

        public static RootOid persistentOf(ObjectSpecId objectSpecId, String identifier, Long versionSequence) {
            return Factory.persistentOf(objectSpecId, identifier, versionSequence, null, null);
        }

        public static RootOid persistentOf(ObjectSpecId objectSpecId, String identifier, Long versionSequence, String versionUser) {
            return Factory.persistentOf(objectSpecId, identifier, versionSequence, versionUser, null);
        }

        public static RootOid persistentOf(ObjectSpecId objectSpecId, String identifier, Long versionSequence, Long versionUtcTimestamp) {
            return Factory.persistentOf(objectSpecId, identifier, versionSequence, null, versionUtcTimestamp);
        }

        public static RootOid persistentOf(ObjectSpecId objectSpecId, String identifier, Long versionSequence, String versionUser, Long versionUtcTimestamp) {
            return Oid_Root.of(objectSpecId, identifier, Oid_State.PERSISTENT, Version.Factory.ifPresent(versionSequence, versionUser, versionUtcTimestamp));
        }

        public static ParentedOid parentedOfOneToMany(RootOid parentRootOid, OneToManyAssociation otma) {
            return Oid_Parented.ofName(parentRootOid, otma.getId());
        }

        public static ParentedOid parentedOfName(RootOid parentRootOid, String name) {
            return Oid_Parented.ofName(parentRootOid, name);
        }
    }

    public static interface Unmarshaller {
        public <T extends Oid> T unmarshal(String var1, Class<T> var2);

        public String splitInstanceId(String var1);
    }

    public static interface Marshaller {
        public String marshal(Version var1);

        public String marshalNoVersion(ParentedOid var1);

        public String marshal(ParentedOid var1);

        public String marshalNoVersion(RootOid var1);

        public String marshal(RootOid var1);

        public String joinAsOid(String var1, String var2);
    }
}

