/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.concurrency;

import java.util.concurrent.Callable;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.config.IsisConfiguration;

public enum ConcurrencyChecking {
    NO_CHECK,
    CHECK;

    private static ThreadLocal<ConcurrencyChecking> concurrencyChecking;

    public static boolean isGloballyDisabled(IsisConfiguration configuration) {
        boolean concurrencyCheckingGloballyDisabled = configuration.getBoolean("isis.persistor.disableConcurrencyChecking", false);
        return concurrencyCheckingGloballyDisabled;
    }

    @Programmatic
    public boolean isChecking() {
        return this == CHECK;
    }

    public static ConcurrencyChecking concurrencyCheckingFor(SemanticsOf actionSemantics) {
        return actionSemantics.isSafeInNature() ? NO_CHECK : CHECK;
    }

    public static boolean isCurrentlyEnabled() {
        return concurrencyChecking.get().isChecking();
    }

    public static <T> T executeWithConcurrencyCheckingDisabled(Callable<T> callable) {
        ConcurrencyChecking prior = null;
        try {
            prior = ConcurrencyChecking.disable();
            T t = callable.call();
            return t;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ConcurrencyChecking.reset(prior);
        }
    }

    public static ConcurrencyChecking disable() {
        ConcurrencyChecking prior = concurrencyChecking.get();
        concurrencyChecking.set(NO_CHECK);
        return prior;
    }

    public static void reset(ConcurrencyChecking prior) {
        if (prior == null) {
            return;
        }
        concurrencyChecking.set(prior);
    }

    public static void executeWithConcurrencyCheckingDisabled(Runnable runnable) {
        ConcurrencyChecking prior = concurrencyChecking.get();
        try {
            ConcurrencyChecking.disable();
            runnable.run();
        }
        finally {
            concurrencyChecking.set(prior);
        }
    }

    static {
        concurrencyChecking = new ThreadLocal<ConcurrencyChecking>(){

            @Override
            protected ConcurrencyChecking initialValue() {
                return CHECK;
            }
        };
    }
}

