/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassUtil;

public final class ClassExtensions {
    private ClassExtensions() {
    }

    public static Object newInstance(Class<?> extendee, Class<?> constructorParamType, Object constructorArg) {
        return ClassExtensions.newInstance(extendee, new Class[]{constructorParamType}, new Object[]{constructorArg});
    }

    public static Object newInstance(Class<?> extendee, Class<?>[] constructorParamTypes, Object[] constructorArgs) {
        try {
            try {
                Constructor<?> constructor = extendee.getConstructor(constructorParamTypes);
                return constructor.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException ex) {
                try {
                    Constructor<?> constructor = extendee.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IsisException((Throwable)e);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new IsisException((Throwable)ex);
        }
    }

    public static String getSuperclass(Class<?> extendee) {
        Class<?> superType = extendee.getSuperclass();
        if (superType == null) {
            return null;
        }
        return superType.getName();
    }

    public static boolean isAbstract(Class<?> extendee) {
        return Modifier.isAbstract(extendee.getModifiers());
    }

    public static boolean isJavaClass(Class<?> extendee) {
        String className = extendee.getName();
        return className.startsWith("java.") || extendee.getName().startsWith("sun.");
    }

    static Class<?> implementingClassOrNull(Class<?> extendee, Class<?> requiredClass, Class<?> constructorParamType) {
        if (extendee == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(extendee)) {
            return null;
        }
        try {
            extendee.getConstructor(constructorParamType);
        }
        catch (NoSuchMethodException ex) {
            try {
                extendee.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        int modifiers = extendee.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        return extendee;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterClass) throws NoSuchMethodException {
        return clazz.getMethod(methodName, parameterClass);
    }

    public static Method getMethodElseNull(Class<?> clazz, String methodName, Class<?> ... parameterClass) {
        try {
            return clazz.getMethod(methodName, parameterClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean exists(Class<?> cls, String resourceName) {
        URL url = _Resources.getResourceUrl(cls, (String)resourceName);
        return url != null;
    }

    static Class<?> asWrapped(Class<?> primitiveClassExtendee) {
        return ClassUtil.wrapperClasses.get(primitiveClassExtendee);
    }

    public static Class<? extends Object> asWrappedIfNecessary(Class<?> cls) {
        return cls.isPrimitive() ? ClassExtensions.asWrapped(cls) : cls;
    }

    public static Object toDefault(Class<?> extendee) {
        if (!extendee.isPrimitive()) {
            return null;
        }
        return ClassUtil.defaultByPrimitiveClass.get(extendee);
    }

    public static Object getNullOrDefault(Class<?> type) {
        return ClassUtil.defaultByPrimitiveType.get(type);
    }

    public static boolean isCompatibleAsReturnType(Class<?> returnTypeExtendee, boolean canBeVoid, Class<?> type) {
        if (returnTypeExtendee == null) {
            return true;
        }
        if (canBeVoid && type == Void.TYPE) {
            return true;
        }
        if (type.isPrimitive()) {
            return returnTypeExtendee.isAssignableFrom(ClassUtil.wrapperClasses.get(type));
        }
        return returnTypeExtendee.isAssignableFrom(type);
    }
}

