/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.ensure;

import java.util.Objects;
import org.apache.isis.core.commons.ensure.IsisAssertException;

public final class Assert {
    public static void assertFalse(String message, boolean flag) {
        Assert.assertTrue(message, !flag);
    }

    public static void assertFalse(String message, Object target, boolean flag) {
        Assert.assertTrue(message, target, !flag);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull("", object);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertTrue("unexpected null: " + message, object != null);
    }

    public static void assertTrue(String message, boolean flag) {
        Assert.assertTrue(message, null, flag);
    }

    public static void assertTrue(String message, Object target, boolean flag) {
        if (!flag) {
            throw new IsisAssertException(message + (target == null ? "" : ": " + target));
        }
    }

    public static void assertEquals(String message, Object left, Object right) {
        if (!Objects.equals(left, right)) {
            throw new IsisAssertException(message + String.format(": '%s' != '%s' ", "" + left, "" + right));
        }
    }
}

