/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.commons.encoding.FailedToDeserializeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldType<T> {
    private static Logger LOG = LoggerFactory.getLogger(FieldType.class);
    private static String LOG_INDENT = ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ";
    private static final int NULL_BIT = 64;
    private static Map<Byte, FieldType<?>> cache = new HashMap();
    private static int next = 0;
    public static FieldType<Boolean> BOOLEAN = new FieldType<Boolean>((byte)next++, Boolean.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Boolean value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeBoolean(value);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                boolean value = inputStream.readBoolean();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Boolean bl = value;
                return bl;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<boolean[]> BOOLEAN_ARRAY = new FieldType<boolean[]>((byte)next++, boolean[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, boolean[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeBoolean(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                boolean[] values = new boolean[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = inputStream.readBoolean();
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                boolean[] blArray = values;
                return blArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Byte> BYTE = new FieldType<Byte>((byte)next++, Byte.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Byte value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeByte(value.byteValue());
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Byte doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                byte value = inputStream.readByte();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Byte by = value;
                return by;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<byte[]> BYTE_ARRAY = new FieldType<byte[]>((byte)next++, byte[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, byte[] values) throws IOException {
            try {
                DataOutputStream outputStream = output.getDataOutputStream();
                int length = values.length;
                outputStream.writeInt(length);
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("length:").append(length).append(" [BYTE ARRAY]"));
                }
                outputStream.write(values);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder().append("length:").append(length).append(" [BYTE ARRAY]");
                    FieldType.log((FieldType)this, msg);
                }
                byte[] bytes = new byte[length];
                this.readBytes(inputStream, bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        private void readBytes(DataInputStream inputStream, byte[] bytes) throws IOException {
            inputStream.read(bytes);
        }
    };
    public static FieldType<Short> SHORT = new FieldType<Short>((byte)next++, Short.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Short value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeShort(value.shortValue());
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Short doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                short value = inputStream.readShort();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Short s = value;
                return s;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<short[]> SHORT_ARRAY = new FieldType<short[]>((byte)next++, short[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, short[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeShort(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected short[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                short[] values = new short[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = inputStream.readShort();
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                short[] sArray = values;
                return sArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Integer> INTEGER = new FieldType<Integer>((byte)next++, Integer.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Integer value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(value);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Integer doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                int value = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Integer n = value;
                return n;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Integer> UNSIGNED_BYTE = new FieldType<Integer>((byte)next++, Integer.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Integer value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeByte(value);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Integer doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                int value = inputStream.readUnsignedByte();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Integer n = value;
                return n;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Integer> UNSIGNED_SHORT = new FieldType<Integer>((byte)next++, Integer.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Integer value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeShort(value);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Integer doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                int value = inputStream.readUnsignedShort();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Integer n = value;
                return n;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<int[]> INTEGER_ARRAY = new FieldType<int[]>((byte)next++, int[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, int[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeInt(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                int[] values = new int[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = inputStream.readInt();
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                int[] nArray = values;
                return nArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Long> LONG = new FieldType<Long>((byte)next++, Long.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Long value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeLong(value.intValue());
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Long doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                long value = inputStream.readLong();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Long l = value;
                return l;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<long[]> LONG_ARRAY = new FieldType<long[]>((byte)next++, long[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, long[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeLong(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                long[] values = new long[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = inputStream.readLong();
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                long[] lArray = values;
                return lArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Character> CHAR = new FieldType<Character>((byte)next++, Character.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Character value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeLong(value.charValue());
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Character doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                char value = inputStream.readChar();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Character c = Character.valueOf(value);
                return c;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<char[]> CHAR_ARRAY = new FieldType<char[]>((byte)next++, char[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, char[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeChar(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected char[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                char[] values = new char[length];
                for (int i = 0; i < values.length; ++i) {
                    if (LOG.isDebugEnabled()) {
                        buf.append(i == 0 ? ": " : ", ");
                        buf.append(values[i]);
                    }
                    values[i] = inputStream.readChar();
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                char[] cArray = values;
                return cArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Float> FLOAT = new FieldType<Float>((byte)next++, Float.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Float value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeFloat(value.floatValue());
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Float doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                float value = inputStream.readFloat();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Float f = Float.valueOf(value);
                return f;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<float[]> FLOAT_ARRAY = new FieldType<float[]>((byte)next++, float[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, float[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeFloat(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected float[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                float[] values = new float[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = inputStream.readFloat();
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                float[] fArray = values;
                return fArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Double> DOUBLE = new FieldType<Double>((byte)next++, Double.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Double value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeDouble(value);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Double doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                double value = inputStream.readDouble();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                Double d = value;
                return d;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<double[]> DOUBLE_ARRAY = new FieldType<double[]>((byte)next++, double[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, double[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    outputStream.writeDouble(values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected double[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                double[] values = new double[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = inputStream.readDouble();
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                double[] dArray = values;
                return dArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<String> STRING = new FieldType<String>((byte)next++, String.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, String value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeUTF(value);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String doRead(DataInputExtended input) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                String value = inputStream.readUTF();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(value));
                }
                String string = value;
                return string;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<String[]> STRING_ARRAY = new FieldType<String[]>((byte)next++, String[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, String[] values) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(values.length);
                }
                for (int i = 0; i < values.length; ++i) {
                    STRING.write(output, values[i]);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String[] doRead(DataInputExtended input) throws IOException {
            try {
                StringBuilder buf = new StringBuilder();
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    buf.append("length: ").append(length);
                }
                String[] values = new String[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = STRING.read(input);
                    if (!LOG.isDebugEnabled()) continue;
                    buf.append(i == 0 ? ": " : ", ");
                    buf.append(values[i]);
                }
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, buf);
                }
                String[] stringArray = values;
                return stringArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }
    };
    public static FieldType<Encodable> ENCODABLE = new FieldType<Encodable>((byte)next++, Encodable.class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Encodable encodable) throws IOException {
            try {
                String className = encodable.getClass().getName();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append(className));
                }
                output.writeUTF(className);
                encodable.encode(output);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        protected Encodable doRead(DataInputExtended input) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        protected boolean checksStream() {
            return false;
        }
    };
    public static FieldType<Encodable[]> ENCODABLE_ARRAY = new FieldType<Encodable[]>((byte)next++, Encodable[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Encodable[] values) throws IOException {
            try {
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("length: ").append(values.length));
                }
                for (Encodable encodable : values) {
                    ENCODABLE.write(output, encodable);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected <Q> Q[] doReadArray(DataInputExtended input, Class<Q> elementType) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("length: ").append(length));
                }
                Object[] values = (Object[])Array.newInstance(elementType, length);
                for (int i = 0; i < values.length; ++i) {
                    values[i] = ENCODABLE.read(input);
                }
                Object[] objectArray = values;
                return objectArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        @Override
        protected boolean checksStream() {
            return false;
        }
    };
    public static FieldType<Serializable> SERIALIZABLE = new FieldType<Serializable>((byte)next++, Serializable.class, Indenting.INDENT_ONLY){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Serializable value) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("[SERIALIZABLE]"));
                }
                ObjectOutputStream oos = new ObjectOutputStream(output.getDataOutputStream());
                oos.writeObject(value);
                oos.flush();
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        @Override
        protected Serializable doRead(DataInputExtended input) throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("[SERIALIZABLE]"));
                }
                ObjectInputStream ois = new ObjectInputStream(input.getDataInputStream());
                try {
                    Serializable serializable = (Serializable)ois.readObject();
                    return serializable;
                }
                catch (ClassNotFoundException ex) {
                    throw new FailedToDeserializeException(ex);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        @Override
        protected boolean checksStream() {
            return false;
        }
    };
    public static FieldType<Serializable[]> SERIALIZABLE_ARRAY = new FieldType<Serializable[]>((byte)next++, Serializable[].class, Indenting.INDENT_AND_OUTDENT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(DataOutputExtended output, Serializable[] values) throws IOException {
            try {
                DataOutputStream outputStream = output.getDataOutputStream();
                outputStream.writeInt(values.length);
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("length: ").append(values.length));
                }
                for (Serializable value : values) {
                    SERIALIZABLE.write(output, value);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected <Q> Q[] doReadArray(DataInputExtended input, Class<Q> elementType) throws IOException {
            try {
                DataInputStream inputStream = input.getDataInputStream();
                int length = inputStream.readInt();
                if (LOG.isDebugEnabled()) {
                    FieldType.log((FieldType)this, new StringBuilder().append("length: ").append(length));
                }
                Object[] values = (Object[])Array.newInstance(elementType, length);
                for (int i = 0; i < values.length; ++i) {
                    values[i] = SERIALIZABLE.read(input);
                }
                Object[] objectArray = values;
                return objectArray;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    FieldType.unlog((FieldType)this);
                }
            }
        }

        @Override
        protected boolean checksStream() {
            return false;
        }
    };
    private final byte idx;
    private final Class<T> cls;
    private final Indenting indenting;
    private static ThreadLocal<int[]> debugIndent = new ThreadLocal();

    public static FieldType<?> get(byte idx) {
        return cache.get(idx);
    }

    private FieldType(byte idx, Class<T> cls, Indenting indenting) {
        this.idx = idx;
        this.cls = cls;
        this.indenting = indenting;
        cache.put(idx, this);
    }

    public byte getIdx() {
        return this.idx;
    }

    public Class<T> getCls() {
        return this.cls;
    }

    protected boolean checksStream() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T read(DataInputExtended input) throws IOException {
        DataInputStream inputStream = input.getDataInputStream();
        byte fieldTypeIdxAndNullability = inputStream.readByte();
        boolean isNull = fieldTypeIdxAndNullability >= 64;
        byte fieldTypeIdx = (byte)(fieldTypeIdxAndNullability - (isNull ? 64 : 0));
        try {
            FieldType<?> fieldType = FieldType.get(fieldTypeIdx);
            if (fieldType == null || fieldType.checksStream() && fieldType != this) {
                throw new IllegalStateException("Mismatch in stream: expected " + this + " but got " + fieldType + " (" + fieldTypeIdx + ")");
            }
            if (isNull && LOG.isDebugEnabled()) {
                FieldType.log(this, new StringBuilder().append("(null)"));
            }
            if (isNull) {
                T t = null;
                return t;
            }
            T t = this.doRead(input);
            return t;
        }
        finally {
            if (isNull && LOG.isDebugEnabled()) {
                FieldType.unlog(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <Q> Q[] readArray(DataInputExtended input, Class<Q> elementType) throws IOException {
        DataInputStream inputStream = input.getDataInputStream();
        byte fieldTypeIdxAndNullability = inputStream.readByte();
        boolean isNull = fieldTypeIdxAndNullability >= 64;
        byte fieldTypeIdx = (byte)(fieldTypeIdxAndNullability - (isNull ? 64 : 0));
        try {
            FieldType<?> fieldType = FieldType.get(fieldTypeIdx);
            if (fieldType.checksStream() && fieldType != this) {
                throw new IllegalStateException("Mismatch in stream: expected " + this + " but got " + fieldType);
            }
            if (isNull && LOG.isDebugEnabled()) {
                FieldType.log(this, new StringBuilder().append("(null)"));
            }
            if (isNull) {
                Q[] QArray = null;
                return QArray;
            }
            Q[] QArray = this.doReadArray(input, elementType);
            return QArray;
        }
        finally {
            if (isNull && LOG.isDebugEnabled()) {
                FieldType.unlog(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(DataOutputExtended output, T value) throws IOException {
        boolean isNull;
        byte fieldTypeIdxAndNullability = this.getIdx();
        boolean bl = isNull = value == null;
        if (isNull) {
            fieldTypeIdxAndNullability = (byte)(fieldTypeIdxAndNullability + 64);
        }
        try {
            DataOutputStream outputStream = output.getDataOutputStream();
            outputStream.write(fieldTypeIdxAndNullability);
            if (isNull && LOG.isDebugEnabled()) {
                FieldType.log(this, new StringBuilder().append("(null)"));
            }
            if (!isNull) {
                this.doWrite(output, value);
            }
        }
        finally {
            if (isNull && LOG.isDebugEnabled()) {
                FieldType.unlog(this);
            }
        }
    }

    protected T doRead(DataInputExtended input) throws IOException {
        throw new UnsupportedOperationException("not supported for this field type");
    }

    protected <Q> Q[] doReadArray(DataInputExtended input, Class<Q> elementType) throws IOException {
        throw new UnsupportedOperationException("not supported for this field type");
    }

    protected abstract void doWrite(DataOutputExtended var1, T var2) throws IOException;

    private boolean isIndentingAndOutdenting() {
        return this.indenting == Indenting.INDENT_AND_OUTDENT;
    }

    private static void log(FieldType<?> fieldType, StringBuilder buf) {
        buf.insert(0, ": ");
        buf.insert(0, fieldType);
        if (super.isIndentingAndOutdenting()) {
            buf.insert(0, "> ");
        }
        buf.insert(0, FieldType.spaces(FieldType.currentDebugLevel()));
        FieldType.incrementDebugLevel();
        LOG.debug(buf.toString());
    }

    private static void unlog(FieldType<?> fieldType) {
        FieldType.unlog(fieldType, new StringBuilder());
    }

    private static void unlog(FieldType<?> fieldType, StringBuilder buf) {
        if (super.isIndentingAndOutdenting()) {
            buf.insert(0, "< ");
        }
        FieldType.decrementDebugLevel();
        if (super.isIndentingAndOutdenting()) {
            buf.insert(0, FieldType.spaces(FieldType.currentDebugLevel()));
            LOG.debug(buf.toString());
        }
    }

    private static String spaces(int num) {
        return LOG_INDENT.substring(0, num);
    }

    private static int currentDebugLevel() {
        return FieldType.debugIndent()[0];
    }

    private static void incrementDebugLevel() {
        int[] indentLevel = FieldType.debugIndent();
        indentLevel[0] = indentLevel[0] + 2;
    }

    private static void decrementDebugLevel() {
        int[] indentLevel = FieldType.debugIndent();
        indentLevel[0] = indentLevel[0] - 2;
    }

    private static int[] debugIndent() {
        int[] indentLevel = debugIndent.get();
        if (indentLevel == null) {
            indentLevel = new int[1];
            debugIndent.set(indentLevel);
        }
        return indentLevel;
    }

    public String toString() {
        return this.getCls().getSimpleName();
    }

    static enum Indenting {
        INDENT_ONLY,
        INDENT_AND_OUTDENT;

    }
}

