/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.components.Installer;

public abstract class InstallerAbstract
implements Installer {
    private final String name;

    public InstallerAbstract(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void init() {
    }

    public void shutdown() {
    }

    protected static List<Class<?>> listOf(Class<?> ... classes) {
        return Collections.unmodifiableList(_NullSafe.stream(classes).collect(Collectors.toList()));
    }

    protected static List<Class<?>> listOf(List<Class<?>> classList, Class<?> ... classes) {
        ArrayList<Class<?>> arrayList = _Lists.newArrayList(classList);
        _NullSafe.stream(classes).forEach(arrayList::add);
        return Collections.unmodifiableList(arrayList);
    }
}

