/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.exceptions;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.functions._Functions;

public final class _Exceptions {
    private _Exceptions() {
    }

    public static final IllegalArgumentException unmatchedCase(@Nullable Object _case) {
        return new IllegalArgumentException("internal error: unmatched case in switch statement: " + _case);
    }

    public static final IllegalArgumentException unmatchedCase(String format, @Nullable Object _case) {
        _With.requires(format, "format");
        return new IllegalArgumentException(String.format(format, _case));
    }

    public static final IllegalStateException unexpectedCodeReach() {
        return new IllegalStateException("internal error: code was reached, that is expected unreachable");
    }

    public static IllegalStateException notImplemented() {
        return new IllegalStateException("internal error: code was reached, that is not implemented yet");
    }

    public static void throwUnexpectedCodeReach() {
        throw _Exceptions.unexpectedCodeReach();
    }

    public static void throwNotImplemented() {
        throw _Exceptions.notImplemented();
    }

    public static <E extends Exception> void throwWhenTrue(E cause, Predicate<E> test) throws E {
        if (test.test(cause)) {
            throw cause;
        }
    }

    public static final Stream<String> streamStacktraceLines(@Nullable Throwable ex, int maxLines) {
        if (ex == null) {
            return Stream.empty();
        }
        return _NullSafe.stream(ex.getStackTrace()).map(StackTraceElement::toString).limit(maxLines);
    }

    public static void dumpStackTrace(PrintStream writer, int skipLines, int maxLines) {
        _NullSafe.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).skip(skipLines).limit(maxLines).forEach(writer::println);
    }

    public static List<Throwable> getCausalChain(@Nullable Throwable ex) {
        if (ex == null) {
            return Collections.emptyList();
        }
        ArrayList<Throwable> chain = _Lists.newArrayList();
        for (Throwable t = ex; t != null; t = t.getCause()) {
            chain.add(t);
        }
        return chain;
    }

    public static Stream<Throwable> streamCausalChain(@Nullable Throwable ex) {
        if (ex == null) {
            return Stream.empty();
        }
        return _Exceptions.getCausalChain(ex).stream();
    }

    public static Throwable getRootCause(@Nullable Throwable ex) {
        return _Lists.lastElementIfAny(_Exceptions.getCausalChain(ex));
    }

    public static class TryContext {
        private final Function<Exception, ? extends RuntimeException> toUnchecked;

        public TryContext(Function<Exception, ? extends RuntimeException> toUnchecked) {
            this.toUnchecked = toUnchecked;
        }

        public Runnable uncheckedRunnable(_Functions.CheckedRunnable checkedRunnable) {
            return checkedRunnable.toUnchecked(this.toUnchecked);
        }

        public void tryRun(_Functions.CheckedRunnable checkedRunnable) {
            this.uncheckedRunnable(checkedRunnable).run();
        }

        public <T, R> Function<T, R> uncheckedFunction(_Functions.CheckedFunction<T, R> checkedFunction) {
            return checkedFunction.toUnchecked(this.toUnchecked);
        }

        public <T, R> R tryApply(T obj, _Functions.CheckedFunction<T, R> checkedFunction) {
            return this.uncheckedFunction(checkedFunction).apply(obj);
        }

        public <T> Consumer<T> uncheckedConsumer(_Functions.CheckedConsumer<T> checkedConsumer) {
            return checkedConsumer.toUnchecked(this.toUnchecked);
        }

        public <T> void tryAccept(T obj, _Functions.CheckedConsumer<T> checkedConsumer) {
            this.uncheckedConsumer(checkedConsumer).accept(obj);
        }
    }

    public static class FluentException<E extends Exception> {
        private final E cause;

        public static <E extends Exception> FluentException<E> of(E cause) {
            return new FluentException<E>(cause);
        }

        private FluentException(E cause) {
            _With.requires(cause, "cause");
            this.cause = cause;
        }

        public E getCause() {
            return this.cause;
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(((Throwable)this.cause).getMessage());
        }

        public void rethrow() throws E {
            throw this.cause;
        }

        public void rethrowIf(Predicate<E> condition) throws E {
            _With.requires(condition, "condition");
            if (condition.test(this.cause)) {
                throw this.cause;
            }
        }

        public void suppressIf(Predicate<E> condition) throws E {
            _With.requires(condition, "condition");
            if (!condition.test(this.cause)) {
                throw this.cause;
            }
        }

        public void rethrowIfMessageContains(String string) throws E {
            _With.requires(string, "string");
            boolean containsMessage = this.getMessage().map(msg -> msg.contains(string)).orElse(false);
            if (containsMessage) {
                throw this.cause;
            }
        }

        public void suppressIfMessageContains(String string) throws E {
            _With.requires(string, "string");
            boolean containsMessage = this.getMessage().map(msg -> msg.contains(string)).orElse(false);
            if (!containsMessage) {
                throw this.cause;
            }
        }
    }
}

