/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Collections;

public final class _Sets {
    private _Sets() {
    }

    public static <T> Set<T> singleton(T element) {
        _With.requires(element, "element");
        return Collections.singleton(element);
    }

    public static <T> Set<T> singletonOrElseEmpty(@Nullable T element) {
        return element != null ? Collections.singleton(element) : Collections.emptySet();
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        _With.requires(elements, "elements");
        if (elements.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> setPreservingOrder = _Sets.newLinkedHashSet();
        Stream.of(elements).forEach(setPreservingOrder::add);
        return Collections.unmodifiableSet(setPreservingOrder);
    }

    public static <T> Set<T> unmodifiable(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(_NullSafe.stream(iterable).collect(Collectors.toSet()));
    }

    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<T> comparator) {
        return comparator != null ? new TreeSet<T>(comparator) : new TreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(@Nullable Iterable<T> iterable) {
        return _NullSafe.stream(iterable).collect(Collectors.toCollection(TreeSet::new));
    }

    public static <T> TreeSet<T> newTreeSet(@Nullable Iterable<T> iterable, @Nullable Comparator<T> comparator) {
        return _NullSafe.stream(iterable).collect(Collectors.toCollection(() -> new TreeSet(comparator)));
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Sets.newHashSet();
        }
        return new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newHashSet, () -> Collectors.toCollection(HashSet::new));
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Sets.newLinkedHashSet();
        }
        return new LinkedHashSet<T>(collection);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newLinkedHashSet, () -> Collectors.toCollection(LinkedHashSet::new));
    }

    public static <T> ConcurrentHashMap.KeySetView<T, Boolean> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    public static <T> ConcurrentHashMap.KeySetView<T, Boolean> newConcurrentHashSet(@Nullable Collection<T> collection) {
        ConcurrentHashMap.KeySetView<T, Boolean> keySetView = _Sets.newConcurrentHashSet();
        if (collection != null) {
            keySetView.addAll(collection);
        }
        return keySetView;
    }

    public static <T> ConcurrentHashMap.KeySetView<T, Boolean> newConcurrentHashSet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newConcurrentHashSet, () -> Collectors.toCollection(ConcurrentHashMap::newKeySet));
    }

    public static <T> CopyOnWriteArraySet<T> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    public static <T> CopyOnWriteArraySet<T> newCopyOnWriteArraySet(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Sets.newCopyOnWriteArraySet();
        }
        return new CopyOnWriteArraySet<T>(collection);
    }

    public static <T> CopyOnWriteArraySet<T> newCopyOnWriteArraySet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newCopyOnWriteArraySet, () -> Collectors.toCollection(CopyOnWriteArraySet::new));
    }

    public static <T> Set<T> intersect(@Nullable Set<T> a, @Nullable Set<T> b) {
        if (a == null && b == null) {
            return Collections.emptySet();
        }
        if (a == null || b == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(a.stream().filter(b::contains).collect(Collectors.toSet()));
    }
}

