/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.isis.commons.internal.base._With;

public class _Multimaps {
    public static <K, V> ListMultimap<K, V> newListMultimap(final Supplier<Map<K, List<V>>> mapFactory, final Supplier<List<V>> elementCollectionFactory) {
        _With.requires(mapFactory, "mapFactory");
        _With.requires(elementCollectionFactory, "elementCollectionFactory");
        return new ListMultimap<K, V>(){
            final Map<K, List<V>> delegate;
            {
                this.delegate = (Map)mapFactory.get();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public List<V> get(Object key) {
                return this.delegate.get(key);
            }

            @Override
            public List<V> put(K key, List<V> value) {
                return this.delegate.put(key, value);
            }

            @Override
            public List<V> remove(Object key) {
                return this.delegate.remove(key);
            }

            @Override
            public void putAll(Map<? extends K, ? extends List<V>> m) {
                this.delegate.putAll(m);
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<List<V>> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K, List<V>>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public void putElement(K key, V value) {
                Collection collection = this.delegate.computeIfAbsent(key, arg_0 -> 1.lambda$putElement$0((Supplier)elementCollectionFactory, arg_0));
                collection.add(value);
            }

            private static /* synthetic */ List lambda$putElement$0(Supplier elementCollectionFactory2, Object __) {
                return (List)elementCollectionFactory2.get();
            }
        };
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap(final Supplier<Map<K, Set<V>>> mapFactory, final Supplier<Set<V>> elementCollectionFactory) {
        _With.requires(mapFactory, "mapFactory");
        _With.requires(elementCollectionFactory, "elementCollectionFactory");
        return new SetMultimap<K, V>(){
            final Map<K, Set<V>> delegate;
            {
                this.delegate = (Map)mapFactory.get();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public Set<V> get(Object key) {
                return this.delegate.get(key);
            }

            @Override
            public Set<V> put(K key, Set<V> value) {
                return this.delegate.put(key, value);
            }

            @Override
            public Set<V> remove(Object key) {
                return this.delegate.remove(key);
            }

            @Override
            public void putAll(Map<? extends K, ? extends Set<V>> m) {
                this.delegate.putAll(m);
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<Set<V>> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K, Set<V>>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public void putElement(K key, V value) {
                Collection collection = this.delegate.computeIfAbsent(key, arg_0 -> 2.lambda$putElement$0((Supplier)elementCollectionFactory, arg_0));
                collection.add(value);
            }

            private static /* synthetic */ Set lambda$putElement$0(Supplier elementCollectionFactory2, Object __) {
                return (Set)elementCollectionFactory2.get();
            }
        };
    }

    public static <K1, K2, V> MapMultimap<K1, K2, V> newMapMultimap(final Supplier<Map<K1, Map<K2, V>>> mapFactory, final Supplier<Map<K2, V>> elementMapFactory) {
        _With.requires(mapFactory, "mapFactory");
        _With.requires(elementMapFactory, "elementMapFactory");
        return new MapMultimap<K1, K2, V>(){
            final Map<K1, Map<K2, V>> delegate;
            {
                this.delegate = (Map)mapFactory.get();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public Map<K2, V> get(Object key) {
                return this.delegate.get(key);
            }

            @Override
            public Map<K2, V> put(K1 key, Map<K2, V> value) {
                return this.delegate.put(key, value);
            }

            @Override
            public Map<K2, V> remove(Object key) {
                return this.delegate.remove(key);
            }

            @Override
            public void putAll(Map<? extends K1, ? extends Map<K2, V>> m) {
                this.delegate.putAll(m);
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }

            @Override
            public Set<K1> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<Map<K2, V>> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K1, Map<K2, V>>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public void putElement(K1 key, K2 subkey, V value) {
                Map elementMap = this.delegate.computeIfAbsent(key, arg_0 -> 3.lambda$putElement$0((Supplier)elementMapFactory, arg_0));
                elementMap.put(subkey, value);
            }

            @Override
            public V getElement(K1 key, K2 subkey) {
                Map elementMap = this.delegate.get(key);
                return elementMap != null ? (Object)elementMap.get(subkey) : null;
            }

            private static /* synthetic */ Map lambda$putElement$0(Supplier elementMapFactory2, Object __) {
                return (Map)elementMapFactory2.get();
            }
        };
    }

    public static <K, V> ListMultimap<K, V> newListMultimap() {
        return _Multimaps.newListMultimap(HashMap::new, ArrayList::new);
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap() {
        return _Multimaps.newSetMultimap(HashMap::new, HashSet::new);
    }

    public static <K1, K2, V> MapMultimap<K1, K2, V> newMapMultimap() {
        return _Multimaps.newMapMultimap(HashMap::new, HashMap::new);
    }

    public static interface MapMultimap<K1, K2, V>
    extends Map<K1, Map<K2, V>> {
        public void putElement(K1 var1, K2 var2, V var3);

        public V getElement(K1 var1, K2 var2);
    }

    public static interface SetMultimap<K, V>
    extends Map<K, Set<V>> {
        public void putElement(K var1, V var2);
    }

    public static interface ListMultimap<K, V>
    extends Map<K, List<V>> {
        public void putElement(K var1, V var2);
    }
}

