/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Collections;

public final class _Lists {
    private _Lists() {
    }

    public static <T> T lastElementIfAny(@Nullable List<T> list) {
        if (_NullSafe.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> List<T> singleton(T element) {
        _With.requires(element, "element");
        return Collections.singletonList(element);
    }

    public static <T> List<T> singletonOrElseEmpty(@Nullable T element) {
        return element != null ? Collections.singletonList(element) : Collections.emptyList();
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        _With.requires(elements, "elements");
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    public static <T> List<T> unmodifiable(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(_NullSafe.stream(iterable).collect(Collectors.toList()));
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Lists.newArrayList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> ArrayList<T> newArrayList(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Lists::newArrayList, () -> Collectors.toCollection(ArrayList::new));
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> newLinkedList(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Lists.newLinkedList();
        }
        return new LinkedList<T>(collection);
    }

    public static <T> LinkedList<T> newLinkedList(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Lists::newLinkedList, () -> Collectors.toCollection(LinkedList::new));
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Lists.newCopyOnWriteArrayList();
        }
        return new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Lists::newCopyOnWriteArrayList, () -> Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    public static <T, R> List<R> transform(@Nullable Collection<T> input, Function<Stream<T>, Stream<R>> transformation) {
        if (input == null) {
            return Collections.emptyList();
        }
        _With.requires(transformation, "transformation");
        return transformation.apply(_NullSafe.stream(input)).collect(Collectors.toList());
    }

    public static <T, R> List<R> map(@Nullable Collection<T> input, Function<T, R> mapper) {
        return _Lists.transform(input, stream -> stream.map(mapper));
    }

    public static <T> List<T> filter(@Nullable Collection<T> input, Predicate<T> filter) {
        return _Lists.transform(input, stream -> stream.filter(filter));
    }
}

