/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.isis.commons.internal.base._With;

class _Collections_Collector<T, C extends Collection<T>>
implements Collector<T, C, C> {
    private final Supplier<C> supplier;
    private final Function<C, C> finisher;

    _Collections_Collector(Supplier<C> supplier, Function<C, C> finisher) {
        this.supplier = _With.requires(supplier, "supplier");
        this.finisher = _With.requires(finisher, "finisher");
    }

    @Override
    public Supplier<C> supplier() {
        return this.supplier;
    }

    @Override
    public BiConsumer<C, T> accumulator() {
        return Collection::add;
    }

    @Override
    public BinaryOperator<C> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<C, C> finisher() {
        return this.finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

