/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._With;

public final class _Reduction<T>
implements Consumer<T> {
    private final BinaryOperator<T> accumulator;
    private T result;
    private boolean initialized = false;

    public static <T> _Reduction<T> of(@Nullable T identity, BinaryOperator<T> accumulator) {
        return new _Reduction<T>(identity, accumulator, true);
    }

    public static <T> _Reduction<T> of(BinaryOperator<T> accumulator) {
        return new _Reduction<Object>(null, accumulator, false);
    }

    private _Reduction(@Nullable T identity, BinaryOperator<T> accumulator, boolean initialized) {
        _With.requires(accumulator, "accumulator");
        this.initialized = initialized;
        this.result = identity;
        this.accumulator = accumulator;
    }

    @Override
    public void accept(@Nullable T next) {
        if (!this.initialized) {
            this.result = next;
            this.initialized = true;
            return;
        }
        this.result = this.accumulator.apply(this.result, next);
    }

    public Optional<T> getResult() {
        if (!this.initialized) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.result);
    }
}

