/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.commons.internal.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._Bytes_GZipCompressorSmart;
import org.apache.isis.commons.internal.base._With;

public final class _Bytes {
    private static final int BUFFER_SIZE = 16384;
    public static final BytesOperator asUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.encodeToBase64(Base64.getUrlEncoder(), bytes));
    public static final BytesOperator ofUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getUrlDecoder(), bytes));
    public static final BytesOperator asCompressedUrlBase64 = _Bytes.operator().andThen(_Bytes::compress).andThen(bytes -> _Bytes.encodeToBase64(Base64.getUrlEncoder(), bytes));
    public static final BytesOperator ofCompressedUrlBase64 = _Bytes.operator().andThen(bytes -> _Bytes.decodeBase64(Base64.getUrlDecoder(), bytes)).andThen(_Bytes::decompress);

    private _Bytes() {
    }

    public static byte[] of(@Nullable InputStream input) throws IOException {
        int nRead;
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        while ((nRead = input.read(buffer, 0, buffer.length)) != -1) {
            bos.write(buffer, 0, nRead);
        }
        bos.flush();
        input.close();
        return bos.toByteArray();
    }

    public static final byte[] prepend(@Nullable byte[] target, byte ... bytes) {
        if (target == null) {
            if (bytes == null) {
                return null;
            }
            return (byte[])bytes.clone();
        }
        if (bytes == null) {
            return (byte[])target.clone();
        }
        byte[] result = new byte[target.length + bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        System.arraycopy(target, 0, result, bytes.length, target.length);
        return result;
    }

    public static final byte[] append(@Nullable byte[] target, byte ... bytes) {
        if (target == null) {
            if (bytes == null) {
                return null;
            }
            return (byte[])bytes.clone();
        }
        if (bytes == null) {
            return (byte[])target.clone();
        }
        byte[] result = new byte[target.length + bytes.length];
        System.arraycopy(target, 0, result, 0, target.length);
        System.arraycopy(bytes, 0, result, target.length, bytes.length);
        return result;
    }

    public static final byte[] encodeToBase64(Base64.Encoder encoder, @Nullable byte[] input) {
        _With.requires(encoder, "encoder");
        return _With.mapIfPresentElse(input, encoder::encode, null);
    }

    public static final byte[] decodeBase64(Base64.Decoder decoder, @Nullable byte[] base64) {
        _With.requires(decoder, "decoder");
        return _With.mapIfPresentElse(base64, decoder::decode, null);
    }

    public static final byte[] compress(@Nullable byte[] input) {
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return input;
        }
        try {
            return _Bytes_GZipCompressorSmart.compress(input);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final byte[] decompress(@Nullable byte[] compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.length == 0) {
            return compressed;
        }
        try {
            return _Bytes_GZipCompressorSmart.decompress(compressed);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BytesOperator operator() {
        return new BytesOperator(UnaryOperator.identity());
    }

    public static final class BytesOperator {
        private final UnaryOperator<byte[]> operator;

        private BytesOperator(UnaryOperator<byte[]> operator) {
            this.operator = _With.requires(operator, "operator");
        }

        public byte[] apply(byte[] input) {
            return (byte[])this.operator.apply(input);
        }

        public BytesOperator andThen(UnaryOperator<byte[]> andThen) {
            return new BytesOperator(s -> (byte[])andThen.apply((byte[])this.operator.apply((byte[])s)));
        }
    }
}

