/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.util.JaxbUtil;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.schema.cmd.v1.ParamDto;
import org.apache.isis.schema.cmd.v1.ParamsDto;
import org.apache.isis.schema.common.v1.InteractionType;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.ValueDto;
import org.apache.isis.schema.common.v1.ValueType;
import org.apache.isis.schema.common.v1.ValueWithTypeDto;
import org.apache.isis.schema.ixn.v1.ActionInvocationDto;
import org.apache.isis.schema.ixn.v1.InteractionDto;
import org.apache.isis.schema.ixn.v1.MemberExecutionDto;
import org.apache.isis.schema.ixn.v1.PropertyEditDto;
import org.apache.isis.schema.utils.CommonDtoUtils;
import org.apache.isis.schema.utils.MemberExecutionDtoUtils;

public final class InteractionDtoUtils {
    static JAXBContext jaxbContext;

    public static void init() {
        InteractionDtoUtils.getJaxbContext();
    }

    static JAXBContext getJaxbContext() {
        if (jaxbContext == null) {
            jaxbContext = JaxbUtil.jaxbContextFor(InteractionDto.class);
        }
        return jaxbContext;
    }

    public static InteractionDto fromXml(Reader reader) {
        try {
            Unmarshaller un = InteractionDtoUtils.getJaxbContext().createUnmarshaller();
            return (InteractionDto)un.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static InteractionDto fromXml(String xml) {
        return InteractionDtoUtils.fromXml(new StringReader(xml));
    }

    public static InteractionDto fromXml(Class<?> contextClass, String resourceName, Charset charset) throws IOException {
        String s = _Resources.loadAsString(contextClass, (String)resourceName, (Charset)charset);
        return InteractionDtoUtils.fromXml(new StringReader(s));
    }

    public static String toXml(InteractionDto interactionDto) {
        CharArrayWriter caw = new CharArrayWriter();
        InteractionDtoUtils.toXml(interactionDto, caw);
        return caw.toString();
    }

    public static void toXml(InteractionDto interactionDto, Writer writer) {
        try {
            Marshaller m = InteractionDtoUtils.getJaxbContext().createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)interactionDto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static MemberExecutionDto.ChildExecutions childExecutionsOf(MemberExecutionDto dto) {
        MemberExecutionDto.ChildExecutions childExecutions = dto.getChildExecutions();
        if (childExecutions == null) {
            childExecutions = new MemberExecutionDto.ChildExecutions();
            dto.setChildExecutions(childExecutions);
        }
        return childExecutions;
    }

    public static InteractionDto newInteractionDto(Interaction.Execution<?, ?> execution) {
        return InteractionDtoUtils.newInteractionDto(execution, Strategy.FLAT);
    }

    public static InteractionDto newInteractionDto(Interaction.Execution<?, ?> execution, Strategy strategy) {
        MemberExecutionDto memberExecutionDto = strategy.dtoFor(execution);
        return InteractionDtoUtils.newInteractionDto(execution, memberExecutionDto);
    }

    private static InteractionDto newInteractionDto(Interaction.Execution<?, ?> execution, MemberExecutionDto executionDto) {
        Interaction interaction = execution.getInteraction();
        String transactionId = interaction.getUniqueId().toString();
        return InteractionDtoUtils.newInteractionDto(transactionId, executionDto);
    }

    private static InteractionDto newInteractionDto(String transactionId, MemberExecutionDto executionDto) {
        InteractionDto interactionDto = new InteractionDto();
        interactionDto.setMajorVersion("1");
        interactionDto.setMinorVersion("0");
        interactionDto.setTransactionId(transactionId);
        interactionDto.setExecution(executionDto);
        executionDto.setInteractionType(executionDto instanceof ActionInvocationDto ? InteractionType.ACTION_INVOCATION : InteractionType.PROPERTY_EDIT);
        return interactionDto;
    }

    public static ActionInvocationDto newActionInvocation(int sequence, Bookmark targetBookmark, String targetTitle, String actionIdentifier, List<ParamDto> parameterDtos, String user) {
        return (ActionInvocationDto)InteractionDtoUtils.newMemberExecutionDto(InteractionType.ACTION_INVOCATION, sequence, targetBookmark, targetTitle, actionIdentifier, parameterDtos, null, user);
    }

    public static PropertyEditDto newPropertyEdit(int sequence, Bookmark targetBookmark, String targetTitle, String propertyIdentifier, ValueWithTypeDto newValueDto, String user) {
        return (PropertyEditDto)InteractionDtoUtils.newMemberExecutionDto(InteractionType.PROPERTY_EDIT, sequence, targetBookmark, targetTitle, propertyIdentifier, null, newValueDto, user);
    }

    private static MemberExecutionDto newMemberExecutionDto(InteractionType type, int sequence, Bookmark targetBookmark, String targetTitle, String memberId, List<ParamDto> parameterDtos, ValueWithTypeDto newValueDto, String user) {
        PropertyEditDto executionDto;
        if (type == InteractionType.ACTION_INVOCATION) {
            ActionInvocationDto invocation = new ActionInvocationDto();
            ParamsDto invocationParameters = InteractionDtoUtils.parametersFor(invocation);
            invocation.setParameters(invocationParameters);
            invocationParameters.getParameter().addAll(parameterDtos);
            executionDto = invocation;
        } else {
            PropertyEditDto edit = new PropertyEditDto();
            edit.setNewValue(newValueDto);
            executionDto = edit;
        }
        executionDto.setSequence(sequence);
        OidDto target = targetBookmark.toOidDto();
        executionDto.setTarget(target);
        executionDto.setTitle(targetTitle);
        executionDto.setUser(user);
        String logicalMemberId = InteractionDtoUtils.deriveLogicalMemberId(targetBookmark, memberId);
        executionDto.setLogicalMemberIdentifier(logicalMemberId);
        executionDto.setMemberIdentifier(memberId);
        return executionDto;
    }

    static String deriveLogicalMemberId(Bookmark bookmark, String memberId) {
        String objectType = bookmark.getObjectType();
        int hashAt = memberId.lastIndexOf("#");
        String localMemberId = hashAt >= 0 && hashAt < memberId.length() ? memberId.substring(hashAt + 1) : memberId;
        return objectType + "#" + localMemberId;
    }

    private static ActionInvocationDto actionInvocationFor(InteractionDto interactionDto) {
        ActionInvocationDto invocation = (ActionInvocationDto)interactionDto.getExecution();
        if (invocation == null) {
            invocation = new ActionInvocationDto();
            interactionDto.setExecution((MemberExecutionDto)invocation);
            invocation.setInteractionType(InteractionType.ACTION_INVOCATION);
        }
        return invocation;
    }

    private static List<ParamDto> parameterListFor(InteractionDto ixnDto) {
        return InteractionDtoUtils.parameterListFor(InteractionDtoUtils.actionInvocationFor(ixnDto));
    }

    private static ParamsDto parametersFor(ActionInvocationDto invocationDto) {
        ParamsDto parameters = invocationDto.getParameters();
        if (parameters == null) {
            parameters = new ParamsDto();
            invocationDto.setParameters(parameters);
        }
        return parameters;
    }

    private static List<ParamDto> parameterListFor(ActionInvocationDto invocationDto) {
        return InteractionDtoUtils.parametersFor(invocationDto).getParameter();
    }

    public static void addParamArg(InteractionDto interactionDto, String parameterName, Class<?> parameterType, Object arg, BookmarkService bookmarkService) {
        List<ParamDto> params = InteractionDtoUtils.parameterListFor(interactionDto);
        ParamDto paramDto = CommonDtoUtils.newParamDto(parameterName, parameterType, arg, bookmarkService);
        params.add(paramDto);
    }

    public static void addReturn(ActionInvocationDto invocationDto, Class<?> returnType, Object result, BookmarkService bookmarkService) {
        ValueWithTypeDto returned = CommonDtoUtils.newValueWithTypeDto(returnType, result, bookmarkService);
        invocationDto.setReturned(returned);
    }

    public static List<ParamDto> getParameters(ActionInvocationDto ai) {
        List<ParamDto> params = InteractionDtoUtils.parameterListFor(ai);
        int parameterNumber = InteractionDtoUtils.getNumberOfParameters(ai);
        ArrayList paramDtos = _Lists.newArrayList();
        for (int i = 0; i < parameterNumber; ++i) {
            ParamDto paramDto = params.get(i);
            paramDtos.add(paramDto);
        }
        return Collections.unmodifiableList(paramDtos);
    }

    private static int getNumberOfParameters(ActionInvocationDto ai) {
        List<ParamDto> params = InteractionDtoUtils.parameterListFor(ai);
        return params != null ? params.size() : 0;
    }

    public static List<String> getParameterNames(ActionInvocationDto ai) {
        return Collections.unmodifiableList(_NullSafe.stream(InteractionDtoUtils.getParameters(ai)).map(CommonDtoUtils.PARAM_DTO_TO_NAME).collect(Collectors.toList()));
    }

    public static List<ValueType> getParameterTypes(ActionInvocationDto ai) {
        return Collections.unmodifiableList(_NullSafe.stream(InteractionDtoUtils.getParameters(ai)).map(CommonDtoUtils.PARAM_DTO_TO_TYPE).collect(Collectors.toList()));
    }

    public static ParamDto getParameter(ActionInvocationDto ai, int paramNum) {
        int parameterNumber = InteractionDtoUtils.getNumberOfParameters(ai);
        if (paramNum > parameterNumber) {
            throw new IllegalArgumentException(String.format("No such parameter %d (the memento has %d parameters)", paramNum, parameterNumber));
        }
        List<ParamDto> parameters = InteractionDtoUtils.getParameters(ai);
        return parameters.get(paramNum);
    }

    public static ValueDto getParameterArgument(ActionInvocationDto ai, int paramNum) {
        return InteractionDtoUtils.getParameter(ai, paramNum);
    }

    public static String getParameterName(ActionInvocationDto ai, int paramNum) {
        ParamDto paramDto = InteractionDtoUtils.getParameter(ai, paramNum);
        return paramDto.getName();
    }

    public static ValueType getParameterType(ActionInvocationDto ai, int paramNum) {
        ParamDto paramDto = InteractionDtoUtils.getParameter(ai, paramNum);
        return paramDto.getType();
    }

    public static boolean isNull(ActionInvocationDto ai, int paramNum) {
        ParamDto paramDto = InteractionDtoUtils.getParameter(ai, paramNum);
        return paramDto.isNull();
    }

    public static <T> T getParameterArgValue(ActionInvocationDto ai, int paramNum, Class<T> inferClass) {
        ParamDto paramDto = InteractionDtoUtils.getParameter(ai, paramNum);
        return CommonDtoUtils.getValue(paramDto);
    }

    public static <T> T getParameterArgValue(ActionInvocationDto ai, int paramNum) {
        ParamDto paramDto = InteractionDtoUtils.getParameter(ai, paramNum);
        return CommonDtoUtils.getValue(paramDto);
    }

    public static void dump(InteractionDto ixnDto, PrintStream out) throws JAXBException {
        out.println(InteractionDtoUtils.toXml(ixnDto));
    }

    public static enum Strategy {
        FLAT{

            @Override
            public MemberExecutionDto dtoFor(Interaction.Execution<?, ?> execution) {
                return execution.getDto();
            }
        }
        ,
        DEEP{

            @Override
            public MemberExecutionDto dtoFor(Interaction.Execution<?, ?> execution) {
                return this.traverse(execution);
            }

            private MemberExecutionDto traverse(Interaction.Execution<?, ?> parentExecution) {
                MemberExecutionDto parentDto = this.clone((MemberExecutionDto)parentExecution.getDto());
                List<Interaction.Execution<?, ?>> children = parentExecution.getChildren();
                for (Interaction.Execution<?, ?> childExecution : children) {
                    MemberExecutionDto childDto = this.clone((MemberExecutionDto)childExecution.getDto());
                    MemberExecutionDto.ChildExecutions childExecutions = InteractionDtoUtils.childExecutionsOf(parentDto);
                    childExecutions.getExecution().add(childDto);
                    this.traverse(childExecution);
                }
                return parentDto;
            }

            private MemberExecutionDto clone(MemberExecutionDto memberExecutionDto) {
                return MemberExecutionDtoUtils.clone(memberExecutionDto);
            }
        };


        public abstract MemberExecutionDto dtoFor(Interaction.Execution<?, ?> var1);
    }
}

