/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.apache.isis.applib.annotation.Value;

@Value(semanticsProviderName="org.apache.isis.core.metamodel.facets.value.localrespath.LocalResourcePathValueSemanticsProvider")
public final class LocalResourcePath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;

    public LocalResourcePath(String path) throws IllegalArgumentException {
        this.validate(path);
        this.path = path != null ? path : "";
    }

    @Nonnull
    public Object getValue() {
        return this.path;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "LocalResourcePath [path=" + this.path + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof LocalResourcePath ? this.isEqualTo((LocalResourcePath)obj) : false;
    }

    public boolean isEqualTo(LocalResourcePath other) {
        if (other == null) {
            return false;
        }
        return this.getPath().equals(other.getPath());
    }

    private void validate(String path) throws IllegalArgumentException {
        if (path == null) {
            return;
        }
        try {
            new URI("http://localhost/" + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("the given local path has an invalid syntax: '" + path + "'", e);
        }
    }
}

