/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public final class JaxbAdapters {

    public static final class OffsetDateTimeAdapter
    extends XmlAdapter<String, OffsetDateTime> {
        public OffsetDateTime unmarshal(String v) throws Exception {
            return OffsetDateTime.parse(v);
        }

        public String marshal(OffsetDateTime v) throws Exception {
            return v.toString();
        }
    }

    public static final class LocalDateTimeAdapter
    extends XmlAdapter<String, LocalDateTime> {
        public LocalDateTime unmarshal(String v) throws Exception {
            return LocalDateTime.parse(v);
        }

        public String marshal(LocalDateTime v) throws Exception {
            return v.toString();
        }
    }

    public static final class LocalDateAdapter
    extends XmlAdapter<String, LocalDate> {
        public LocalDate unmarshal(String v) throws Exception {
            return LocalDate.parse(v);
        }

        public String marshal(LocalDate v) throws Exception {
            return v.toString();
        }
    }

    public static final class SqlTimestampAdapter
    extends XmlAdapter<String, Timestamp> {
        public Timestamp unmarshal(String v) throws Exception {
            return new Timestamp(Long.parseLong(v));
        }

        public String marshal(Timestamp v) throws Exception {
            return Long.toString(v.getTime());
        }
    }

    public static final class SqlDateAdapter
    extends XmlAdapter<String, java.sql.Date> {
        public java.sql.Date unmarshal(String v) throws Exception {
            return java.sql.Date.valueOf(v);
        }

        public String marshal(java.sql.Date v) throws Exception {
            return v.toString();
        }
    }

    public static final class DateAdapter
    extends XmlAdapter<String, Date> {
        public Date unmarshal(String v) throws Exception {
            return new Date(Long.parseLong(v));
        }

        public String marshal(Date v) throws Exception {
            return Long.toString(v.getTime());
        }
    }
}

