/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.tree;

import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.tree.LazyTreeNode;
import org.apache.isis.applib.tree.TreeAdapter;
import org.apache.isis.applib.tree.TreeNode_iteratorBreadthFirst;
import org.apache.isis.applib.tree.TreeNode_iteratorDepthFirst;
import org.apache.isis.applib.tree.TreeNode_iteratorHierarchyUp;
import org.apache.isis.applib.tree.TreePath;
import org.apache.isis.applib.tree.TreeState;
import org.apache.isis.commons.internal.base._NullSafe;

public interface TreeNode<T> {
    public T getValue();

    @Nullable
    public TreeNode<T> getParentIfAny();

    public int getChildCount();

    public Stream<TreeNode<T>> streamChildren();

    default public boolean isRoot() {
        return this.getParentIfAny() == null;
    }

    default public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public TreePath getPositionAsPath();

    public TreeState getTreeState();

    default public boolean isExpanded(TreePath treePath) {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        return expandedPaths.contains(treePath);
    }

    @Programmatic
    default public void expand(TreePath ... treePaths) {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        _NullSafe.stream((Object[])treePaths).forEach(expandedPaths::add);
    }

    @Programmatic
    default public void collapse(TreePath ... treePaths) {
        Set<TreePath> expandedPaths = this.getTreeState().getExpandedNodePaths();
        _NullSafe.stream((Object[])treePaths).forEach(expandedPaths::remove);
    }

    public static <T> TreeNode<T> lazy(T node, Class<? extends TreeAdapter<T>> treeAdapterClass) {
        return LazyTreeNode.of(node, treeAdapterClass, TreeState.rootCollapsed());
    }

    default public Iterator<TreeNode<T>> iteratorHierarchyUp() {
        return new TreeNode_iteratorHierarchyUp(this);
    }

    default public Stream<TreeNode<T>> streamHierarchyUp() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iteratorHierarchyUp(), 16), false);
    }

    default public Iterator<TreeNode<T>> iteratorDepthFirst() {
        return new TreeNode_iteratorDepthFirst(this);
    }

    default public Iterator<TreeNode<T>> iteratorBreadthFirst() {
        return new TreeNode_iteratorBreadthFirst(this);
    }

    default public Stream<TreeNode<T>> streamDepthFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iteratorDepthFirst(), 16), false);
    }

    default public Stream<TreeNode<T>> streamBreadthFirst() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iteratorBreadthFirst(), 16), false);
    }

    public Class<? extends TreeAdapter<T>> getTreeAdapterClass();
}

