/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.xmlsnapshot;

import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.isis.applib.services.xmlsnapshot.XmlSnapshotService;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlSnapshotServiceAbstract
implements XmlSnapshotService {
    @Override
    public Document asDocument(String xmlStr) {
        try {
            StringReader reader = new StringReader(xmlStr);
            StreamSource streamSource = new StreamSource(reader);
            DOMResult result = new DOMResult();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(streamSource, result);
            Node node = result.getNode();
            return (Document)node;
        }
        catch (TransformerException e) {
            throw new XmlSnapshotService.Exception(e);
        }
    }

    @Override
    public <T> T getChildElementValue(Element el, String tagname, Class<T> expectedCls) {
        Element chldEl = this.getChildElement(el, tagname);
        String dataType = chldEl.getAttribute("isis:datatype");
        if (dataType == null) {
            throw new IllegalArgumentException("unable to locate " + tagname + "/@datatype attribute");
        }
        if ("isis:String".equals(dataType)) {
            return (T)this.getChildTextValue(chldEl);
        }
        if ("isis:LocalDate".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            DateTimeFormatter forPattern = DateTimeFormat.forPattern((String)"dd-MMM-yyyy").withLocale(Locale.ENGLISH);
            return (T)forPattern.parseLocalDate(str);
        }
        if ("isis:Byte".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Byte(str);
        }
        if ("isis:Short".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Short(str);
        }
        if ("isis:Integer".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Integer(str);
        }
        if ("isis:Long".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Long(str);
        }
        if ("isis:Float".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Float(str);
        }
        if ("isis:Double".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Double(str);
        }
        if ("isis:BigDecimal".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new BigDecimal(str);
        }
        if ("isis:BigInteger".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new BigInteger(str);
        }
        if ("isis:Boolean".equals(dataType)) {
            String str = this.getChildTextValue(chldEl);
            return (T)new Boolean(str);
        }
        throw new IllegalArgumentException("Datatype of '" + dataType + "' for element '" + tagname + "' not recognized");
    }

    @Override
    public Element getChildElement(Element el, String tagname) {
        NodeList elementsByTagName = el.getElementsByTagName(tagname);
        int length = elementsByTagName.getLength();
        if (length != 1 || !(elementsByTagName.item(0) instanceof Element)) {
            throw new IllegalArgumentException("unable to locate " + tagname + " element");
        }
        Element item = (Element)elementsByTagName.item(0);
        return item;
    }

    @Override
    public String getChildTextValue(Element el) {
        NodeList childNodes = el.getChildNodes();
        if (childNodes.getLength() != 1 || !(childNodes.item(0) instanceof Text)) {
            throw new IllegalArgumentException("unable to locate app:reference/text() node");
        }
        Text referenceText = (Text)childNodes.item(0);
        return referenceText.getData();
    }
}

