/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.queryresultscache;

import java.util.Map;
import java.util.concurrent.Callable;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.WithTransactionScope;
import org.apache.isis.applib.services.queryresultscache.QueryResultCacheControl;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
@RequestScoped
public class QueryResultsCacheInternal
implements QueryResultsCache,
WithTransactionScope {
    private static final Logger LOG = LoggerFactory.getLogger(QueryResultsCacheInternal.class);
    private final Map<QueryResultsCache.Key, QueryResultsCache.Value<?>> cache = _Maps.newHashMap();
    @Inject
    protected QueryResultCacheControl control;

    @Override
    @Programmatic
    public <T> T execute(Callable<T> callable, Class<?> callingClass, String methodName, Object ... keys) {
        if (this.control.isFixturesInstalling()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        QueryResultsCache.Key cacheKey = new QueryResultsCache.Key(callingClass, methodName, keys);
        return this.executeWithCaching(callable, cacheKey);
    }

    @Programmatic
    private <T> T execute(Callable<T> callable, QueryResultsCache.Key cacheKey) {
        if (this.control.isFixturesInstalling()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.executeWithCaching(callable, cacheKey);
    }

    private <T> T executeWithCaching(Callable<T> callable, QueryResultsCache.Key cacheKey) {
        try {
            QueryResultsCache.Value<?> cacheValue = this.cache.get(cacheKey);
            QueryResultsCacheInternal.logHitOrMiss(cacheKey, cacheValue);
            if (cacheValue != null) {
                return (T)_Casts.uncheckedCast(cacheValue.getResult());
            }
            T result = callable.call();
            this.put(cacheKey, result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Programmatic
    private <T> QueryResultsCache.Value<T> get(Class<?> callingClass, String methodName, Object ... keys) {
        return this.get(new QueryResultsCache.Key(callingClass, methodName, keys));
    }

    @Programmatic
    private <T> QueryResultsCache.Value<T> get(QueryResultsCache.Key cacheKey) {
        QueryResultsCache.Value<?> value = this.cache.get(cacheKey);
        QueryResultsCacheInternal.logHitOrMiss(cacheKey, value);
        return value;
    }

    @Programmatic
    private <T> void put(QueryResultsCache.Key cacheKey, T result) {
        LOG.debug("PUT: {}", (Object)cacheKey);
        this.cache.put(cacheKey, new QueryResultsCache.Value<T>(result));
    }

    private static void logHitOrMiss(QueryResultsCache.Key cacheKey, QueryResultsCache.Value<?> cacheValue) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("{}: {}", (Object)(cacheValue != null ? "HIT" : "MISS"), (Object)cacheKey.toString());
    }

    @Override
    @Programmatic
    public void resetForNextTransaction() {
        this.cache.clear();
    }
}

